/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.services.payment.linkpay;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbPacker;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryLinkPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = YnhtbPacker.packRoot();
        Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
        Element header = YnhtbPacker.packReqHead("510011", Sequence.gen16Sequence());
        JDomUtils.addChild((Element)reqData, (Element)header);
        Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)paymentInfo.getThirdAccNo());
        if (paymentInfo.getSubmitSuccessTime() == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u63d0\u4ea4\u65f6\u95f4\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2", (String)"QueryLinkPayImpl_1", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)reqParam, (String)"OldTermDate", (String)LocalDateUtil.formatDate((LocalDate)paymentInfo.getSubmitSuccessTime().toLocalDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"OldSeqNo", (String)paymentInfo.getBankBatchSeqID());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = YnhtbParser.parseString2Root(res);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if (!"000000".equalsIgnoreCase(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)rspMsg));
        }
        Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
        String subTranStatus = result.getChildText("SubTranStatus");
        String subTranStatusDesc = result.getChildText("SubTranStatusDesc");
        String tranStatus = result.getChildText("TranStatus");
        String tranStatusDesc = result.getChildText("TranStatusDesc");
        if (PaymentState.SUCCESS == this.resultStatusMap(subTranStatus)) {
            PaymentState paymentState = this.resultStatusMap(tranStatus);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)paymentState, (String)paymentState.getCnName(), (String)tranStatus, (String)tranStatusDesc);
        } else if (PaymentState.FAIL == this.resultStatusMap(subTranStatus)) {
            PaymentState paymentState = this.resultStatusMap(tranStatus);
            if (PaymentState.FAIL == paymentState) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)tranStatus, (String)tranStatusDesc);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)tranStatus, (String)tranStatusDesc);
            }
        } else if (PaymentState.SUBMITED == this.resultStatusMap(subTranStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)subTranStatus, (String)subTranStatusDesc);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)subTranStatus, (String)subTranStatusDesc);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "510011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u540c\u6b65", (String)"QueryLinkPayImpl_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]);
    }

    public PaymentState resultStatusMap(String status) {
        if ("2".equals(status)) {
            return PaymentState.SUCCESS;
        }
        if ("1".equals(status) || "3".equals(status) || "5".equals(status)) {
            return PaymentState.FAIL;
        }
        if ("0".equals(status)) {
            return PaymentState.SUBMITED;
        }
        return PaymentState.UNKNOWN;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

