/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dcn.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Packer;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Signature;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/linkbank/");
        sb.append(this.getBizCode());
        sb.append(".do");
        factory.setUri(sb.toString());
        factory.setHttpHeader("signature", RequestContextUtils.getRunningParam((String)"sign"));
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = Packer.packCommHeader();
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"linkReqList");
        JDomUtils.addChild((Element)listElement, (String)"accNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)listElement, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)listElement, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String data = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        String sign = Signature.getInstance().sign(data, this.getBizCode());
        RequestContextUtils.setRunningParam((String)"sign", (String)sign);
        return data;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        Element row;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("body");
        Element mapElement = body.getChild("linkRespList");
        String errorCode = mapElement.getChildTextTrim("errorCode");
        String errorMsg = mapElement.getChildTextTrim("errorMsg");
        if (!"0".equals(errorCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)errorCode, (String)errorMsg));
        }
        ArrayList<DetailInfo> lists = new ArrayList<DetailInfo>(16);
        String accNo = mapElement.getChildTextTrim("accNo");
        List rowList = mapElement.getChildren("iAccDetailQuery");
        if (CollectionUtil.isEmpty((Collection)rowList)) {
            return new EBBankDetailResponse(lists);
        }
        if (rowList.size() == 1 && CollectionUtil.isEmpty((Collection)(row = (Element)rowList.get(0)).getContent())) {
            return new EBBankDetailResponse(lists);
        }
        for (int i = 0; i < rowList.size(); ++i) {
            Element row2 = (Element)rowList.get(i);
            String transDate = row2.getChildTextTrim("transDate");
            String transTime = row2.getChildTextTrim("transTime");
            String cur = row2.getChildTextTrim("currency");
            String cd_flag = row2.getChildTextTrim("transFlag");
            String tran_amount = row2.getChildTextTrim("amount");
            String balance = row2.getChildTextTrim("balance");
            String oppAcctNo = row2.getChildTextTrim("partnerAccNo");
            String oppAccName = row2.getChildTextTrim("partnerAccName");
            String partnerBankName = row2.getChildTextTrim("partnerBankName");
            String use = row2.getChildTextTrim("use");
            String transFlowNo = row2.getChildTextTrim("transFlowNo");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setOppAccName(oppAccName);
            detailInfo.setOppAccNo(oppAcctNo);
            detailInfo.setOppBankName(partnerBankName);
            detailInfo.setCurrency(cur);
            if (!StringUtils.isEmpty((String)transDate)) {
                detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                if (StringUtils.isEmpty((String)transTime)) {
                    detailInfo.setTransTime(LocalDateTime.parse(transDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                } else {
                    detailInfo.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
            }
            if ("1".equals(cd_flag)) {
                detailInfo.setCreditAmount(new BigDecimal(tran_amount));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else if ("0".equals(cd_flag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(tran_amount));
                detailInfo.setPayBankDetailSeqID(transFlowNo);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u65b9\u5411<transFlag>\u4e3a%s,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u7684\u501f\u8d37\u65b9\u5411", (String)"DetailImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), cd_flag));
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            detailInfo.setExplanation(use);
            String json = MatchRule.getInstance().getDetailJsonWithStructuredData(row2);
            detailInfo.setJsonMap(json);
            lists.add(detailInfo);
        }
        return new EBBankDetailResponse(lists);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "LB00002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]);
    }
}

