/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit.openCredit.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.ebg.aqap.business.credit.openCredit.Task.BankQueryOpenCreditTask;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import net.sf.json.JSONObject;

public class QueryOpenCreditUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryOpenCreditUtil.class);

    public static Set<List<OpenCreditDetail>> setOfPay(List<OpenCreditDetail> infos) {
        HashMap map = Maps.newHashMap();
        Map<String, Long> countMap = infos.stream().collect(Collectors.groupingBy(OpenCreditDetail::getBankBatchSeqId, Collectors.counting()));
        List toQuery = infos.stream().filter(info -> info.getStatus().intValue() == PaymentState.SUBMITED.getId() || info.getStatus().intValue() == PaymentState.UNKNOWN.getId() || info.getStatus().intValue() == PaymentState.SUBMITTING.getId()).collect(Collectors.toList());
        for (OpenCreditDetail info2 : toQuery) {
            String bankBatchSeqId = info2.getBankBatchSeqId();
            Long count = countMap.get(bankBatchSeqId);
            info2.setBankBatchCount(count.intValue());
            if (map.containsKey(bankBatchSeqId)) {
                ((List)map.get(bankBatchSeqId)).add(info2);
                continue;
            }
            map.put(bankBatchSeqId, Lists.newArrayList());
            ((List)map.get(bankBatchSeqId)).add(info2);
        }
        return Sets.newHashSet(map.values());
    }

    public static void async(Set<List<OpenCreditDetail>> set, EBRequest request, BankAcnt acnt, String type) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<OpenCreditDetail> infos : set) {
            BankOpenCreditDetailRequest openCreditDetailRequest = QueryOpenCreditUtil.getQueryOpenCreditRequest(infos, acnt);
            OpenCreditDetail openCreditDetail = infos.get(0);
            String bankVersion = openCreditDetail.getBankVersionID();
            String bizType = "openCreditQuery";
            String customerId = acnt.getCustomID();
            String batchSeqId = openCreditDetail.getBatchSeqId();
            String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(request.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(request.getHeader().getLogBizSeqID());
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(EBContext.getContext().getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(openCreditDetail.getBankBatchSeqId()).loggerBankNo(loggerBankNo).build();
            String bankLoginId = openCreditDetailRequest.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
            openCreditDetailRequest.setBankBatchSeqID(bankBatchSeqID);
            openCreditDetailRequest.setForceQuery(type);
            openCreditDetailRequest.setDetails(infos);
            openCreditDetailRequest.setTotalCount(infos.size());
            context.setBankAcnt(acnt);
            EBThreadPools.getQueryCreditThreadPool(customerId, bankLoginId).submit((Callable)((Object)new BankQueryOpenCreditTask(openCreditDetailRequest, context)));
        }
    }

    private static BankOpenCreditDetailRequest getQueryOpenCreditRequest(List<OpenCreditDetail> infos, BankAcnt bankAcnt) {
        BankOpenCreditDetailRequest request = new BankOpenCreditDetailRequest();
        String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
        request.setBankBatchSeqID(bankBatchSeqID);
        request.setDetails(infos);
        request.setTotalCount(infos.size());
        request.setHeader(QueryOpenCreditUtil.getHeader(infos.get(0), bankAcnt));
        return request;
    }

    private static BankHeader getHeader(OpenCreditDetail info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = bankAcnt;
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankQueryOpenCreditTask");
        header.setClientVersion("1.0");
        return header;
    }
}

