/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.file;

import com.google.common.base.Preconditions;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.file.AbstractAttachmentImpl;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.slf4j.MDC;

public abstract class AbstractAttachmentSftpImpl
extends AbstractAttachmentImpl {
    protected void attachmentRelatePay(List<PayAttachment> attachments, ChannelSftp channelSftp) {
    }

    protected void reNameAttachName(PayAttachment attachment) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankAttachmentResponse doBiz(BankAttachmentRequest bankAttachmentRequest) {
        List<PayAttachment> attachments = bankAttachmentRequest.getPayAttachments();
        if (CollectionUtil.isEmpty(attachments)) {
            return new BankAttachmentResponse(attachments);
        }
        attachments.forEach(payAttachment -> this.reNameAttachName((PayAttachment)payAttachment));
        super.prepareAttachment(attachments);
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        ChannelSftp channelSftp = this.getChannelSftp();
        Preconditions.checkNotNull((Object)channelSftp, (Object)"sftp connect fail");
        try {
            ChannelSftp finalChannelSftp = channelSftp;
            attachments.forEach(payAttachment -> {
                EBContext context = EBContext.getContext();
                IParameter parameter = context.getParameter();
                String uploadPath = parameter.getBankParameter("upload_sftp_path");
                boolean uploadSuccess = this.uploadToBankBySFTP(finalChannelSftp, super.getOverseaAttachmentPath(payAttachment.getBankVersionID()), payAttachment.getFileName(), uploadPath);
                if (uploadSuccess) {
                    try {
                        EBContext.getContext().setProcessFlag(PROCESS_PACK);
                        String rqstStr = this.pack((PayAttachment)payAttachment);
                        this.logger.info("\u9644\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u62a5\u6587:" + rqstStr);
                        String rspStr = this.sendAndRecvMsg(rqstStr);
                        this.logger.info("\u9644\u4ef6\u4e0a\u4f20\u54cd\u5e94\u62a5\u6587:" + rspStr);
                        this.parse((PayAttachment)payAttachment, rspStr);
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((Throwable)e);
                    }
                } else {
                    this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.FAIL, "", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20sftp\u5931\u8d25", (String)"AbstractAttachmentSftpImpl_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            });
            this.attachmentRelatePay(attachments, channelSftp);
        }
        finally {
            try {
                if (channelSftp != null) {
                    Session session = channelSftp.getSession();
                    if (session != null && session.isConnected()) {
                        session.disconnect();
                    }
                    channelSftp.disconnect();
                }
            }
            catch (JSchException e) {
                this.logger.error("\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", (Throwable)e);
            }
        }
        return new BankAttachmentResponse(attachments);
    }
}

