/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.financing.status.FinancingStatusRequest;
import kd.ebg.aqap.common.entity.biz.financing.status.FinancingStatusResponse;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;

public class UpdateFinancingStatusMethod
implements EBServiceMethod<FinancingStatusRequest, FinancingStatusResponse> {
    public FinancingStatusResponse executeClientRequest(FinancingStatusRequest request, EBContext context) {
        this.checkStructure(request);
        List details = request.getBody().getDetails();
        HashSet bathSeqID = new HashSet();
        details.forEach(detail -> {
            Preconditions.checkArgument((detail.getModifyStatus() == 12 || detail.getModifyStatus() == 13 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u679a\u4e3e\u6709\u8bef\u3002", (String)"UpdateFinancingStatusMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StrUtil.isEmpty((String)detail.getUpdateReason()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateFinancingStatusMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            bathSeqID.add(detail.getBatchSeqID());
        });
        bathSeqID.forEach(id -> this.checkBatchSeqIDUnique((String)id));
        FinancingService service = FinancingService.getInstance();
        details.forEach(detail -> {
            List infos = service.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
            if (infos.size() == 1) {
                FinancingInfo info = (FinancingInfo)infos.get(0);
                if (FinancingState.UNKNOWN.getId() != info.getStatus().intValue()) {
                    detail.setUpdateStatus("BANK_FAIL");
                    detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u672a\u786e\u8ba4\u72b6\u6001\u7684\u8bb0\u5f55\u3002", (String)"UpdateFinancingStatusMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                } else {
                    FinancingInfo infoClone = new FinancingInfo();
                    FieldUtils.fieldsCopy((Object)info, (Object)infoClone);
                    FinancingState state = FinancingState.getEnumById((int)detail.getModifyStatus());
                    info.setStatus(Integer.valueOf(state.getId()));
                    info.setStatusName(state.getEnName());
                    info.setStatusMsg(state.getCnName());
                    try {
                        service.save(infos);
                        detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5b8c\u6210", (String)"UpdateFinancingStatusMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        detail.setUpdateStatus("BANK_FAIL");
                        detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff1a%s\u3002", (String)"UpdateFinancingStatusMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()));
                    }
                    infos = service.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
                    info = (FinancingInfo)infos.get(0);
                    FinancingState financingState = FinancingState.getEnumById((int)info.getStatus());
                    EbStatus status = EbStatus.convertBankState2EBG((FinancingState)financingState);
                    detail.setEbStatus(status.getName());
                    if (financingState.getId() == detail.getModifyStatus()) {
                        detail.setUpdateStatus("BANK_SUCCESS");
                    } else {
                        detail.setUpdateStatus("BANK_FAIL");
                    }
                }
            } else {
                detail.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"UpdateFinancingStatusMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
                detail.setUpdateStatus("BANK_FAIL");
            }
        });
        FinancingStatusResponse response = new FinancingStatusResponse();
        response.setBody(request.getBody());
        return response;
    }

    private void checkStructure(FinancingStatusRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4fee\u6539\u7406\u8d22\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateFinancingStatusMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (request.getBody().getDetails() != null) {
                    Preconditions.checkArgument((request.getBody().getTotalCount() == request.getBody().getDetails().size() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u7b14\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26\u3002", (String)"UpdateFinancingStatusMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((boolean)FinancingService.getInstance().batchSeqIDExist(batchSeqID), (Object)MultiLang.getBatchEmptyTip());
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return BizName.UPDATE_FINANCING_STATUS.name();
    }
}

