/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing.util;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequestBody;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequestDetail;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingResponse;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingResponseBody;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingResponseDetail;
import kd.ebg.aqap.common.entity.biz.financing.buy.QueryBuyFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.buy.QueryBuyFinancingResponse;
import kd.ebg.aqap.common.entity.biz.financing.buy.QueryBuyFinancingResponseBody;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingResponse;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingResponseBody;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequestBody;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequestDetail;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingResponse;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingResponseBody;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

public class FinancingConvert {
    public static BankQueryFinancingDetailRequest convert(QueryFinancingRequest request) {
        BankQueryFinancingDetailRequest result = new BankQueryFinancingDetailRequest();
        BankHeader header = new BankHeader();
        result.setHeader(header);
        header.setBizType(request.getHeader().getBizType());
        header.setSubBizType(request.getHeader().getSubBizType());
        header.setClientName(request.getHeader().getClientName());
        header.setClientVersion(request.getHeader().getClientVersion());
        header.setExtData(request.getHeader().getExtData());
        header.setBankVersionID(request.getBody().getBankVersionID());
        header.setBankLoginID(request.getBody().getBankLoginID());
        header.setBizSeqID(request.getHeader().getLogBizSeqID());
        header.setCustomerID(request.getHeader().getCustomId());
        result.setPageSize(request.getBody().getPageSize());
        result.setPageNum(1);
        result.setBankVersionID(request.getBody().getBankVersionID());
        result.setBankLoginID(request.getBody().getBankLoginID());
        result.setProductCode(request.getBody().getProductCode());
        return result;
    }

    public static BankFinancingRequest getBankFinancingRequest(List<FinancingInfo> infos, EBRequest ebRequest) {
        BankFinancingRequest request = new BankFinancingRequest();
        String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
        request.setBatchSeqId(bankBatchSeqID);
        request.setInfos(infos);
        request.setTotalCount(infos.size());
        request.setHeader(FinancingConvert.getHeader(infos.get(0), ebRequest.getHeader().getBizType()));
        request.getHeader().setExtData(ebRequest.getHeader().getExtData());
        return request;
    }

    private static BankHeader getHeader(FinancingInfo info, String bizType) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(info.getAccNo(), info.getCustomId());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomId());
        header.setCustomerID(info.getCustomId());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(bizType);
        header.setSubBizType(bizType);
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebg_bankQueryFinancingTask");
        header.setClientVersion("1.0");
        return header;
    }

    public static BankFinancingRequest convert(BuyFinancingRequest request) {
        BankFinancingRequest result = new BankFinancingRequest();
        BuyFinancingRequestBody requestBody = request.getBody();
        EBHeader requestHeader = request.getHeader();
        BankHeader header = new BankHeader();
        result.setHeader(header);
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setBizType(request.getHeader().getBizType());
        header.setBizSeqID(request.getHeader().getLogBizSeqID());
        header.setCustomerID(request.getHeader().getCustomId());
        header.setSubBizType(request.getHeader().getSubBizType());
        header.setClientName(request.getHeader().getClientName());
        header.setClientVersion(request.getHeader().getClientVersion());
        List details = request.getBody().getDetails();
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        EBContext context = EBContext.getContext();
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(context.getBankVersionID());
        String bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
        EBContext.getContext().setBizSeqID(bankBatchSeqID);
        for (BuyFinancingRequestDetail detail : details) {
            FinancingInfo info = new FinancingInfo();
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            info.setFinancingType("B");
            info.setErrorMsg("");
            info.setBackErrorMsg("");
            info.setBankMsg("");
            info.setCustomId(requestHeader.getCustomId());
            info.setBatchSeqId(requestBody.getBatchSeqId());
            info.setBankVersionID(context.getBankVersionID());
            info.setBankLoginID(context.getBankLoginID());
            info.setAccNo(detail.getAccNo());
            info.setStatus(Integer.valueOf(FinancingState.PACKAGED.getId()));
            info.setStatusMsg(FinancingState.PACKAGED.getCnName());
            info.setStatusName(FinancingState.PACKAGED.getEnName());
            info.setBankStatus("");
            info.setBankStatusMsg("");
            String currency = detail.getCurrency();
            info.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            info.setBankBatchSeqId(bankBatchSeqID);
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(context.getBankVersionID());
            String bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankFinancingSeqId(bankDetailSeqID);
            info.setEbSeqId(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
            infos.add(info);
        }
        result.setInfos(infos);
        result.setBatchSeqId(request.getBody().getBatchSeqId());
        result.setBatchBizNo(request.getBody().getBatchBizNo());
        return result;
    }

    public static BankFinancingRequest convert(RedeemFinancingRequest request) {
        BankFinancingRequest result = new BankFinancingRequest();
        RedeemFinancingRequestBody requestBody = request.getBody();
        EBHeader requestHeader = request.getHeader();
        BankHeader header = new BankHeader();
        result.setHeader(header);
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setBizType(request.getHeader().getBizType());
        header.setBizSeqID(request.getHeader().getLogBizSeqID());
        header.setCustomerID(request.getHeader().getCustomId());
        header.setSubBizType(request.getHeader().getSubBizType());
        header.setClientName(request.getHeader().getClientName());
        header.setClientVersion(request.getHeader().getClientVersion());
        List details = request.getBody().getDetails();
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        EBContext context = EBContext.getContext();
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(context.getBankVersionID());
        String bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
        EBContext.getContext().setBizSeqID(bankBatchSeqID);
        for (RedeemFinancingRequestDetail detail : details) {
            FinancingInfo info = new FinancingInfo();
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            info.setFinancingType("R");
            info.setErrorMsg("");
            info.setBackErrorMsg("");
            info.setBankMsg("");
            info.setCustomId(requestHeader.getCustomId());
            info.setBatchSeqId(requestBody.getBatchSeqId());
            info.setBankVersionID(context.getBankVersionID());
            info.setBankLoginID(context.getBankLoginID());
            info.setAccNo(detail.getAccNo());
            info.setStatus(Integer.valueOf(FinancingState.PACKAGED.getId()));
            info.setStatusMsg(FinancingState.PACKAGED.getCnName());
            info.setStatusName(FinancingState.PACKAGED.getEnName());
            info.setBankStatus("");
            info.setBankStatusMsg("");
            String currency = detail.getCurrency();
            info.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            info.setBankBatchSeqId(bankBatchSeqID);
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(context.getBankVersionID());
            String bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankFinancingSeqId(bankDetailSeqID);
            info.setEbSeqId(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
            infos.add(info);
        }
        result.setInfos(infos);
        result.setBatchSeqId(request.getBody().getBatchSeqId());
        result.setBatchBizNo(request.getBody().getBatchBizNo());
        return result;
    }

    public static BuyFinancingResponse convert(List<FinancingInfo> infos, String iso) {
        BuyFinancingResponse result = new BuyFinancingResponse();
        EBHeader header = new EBHeader();
        header.setResponseTime((long)LocalDateTime.now().getNano());
        result.setHeader(header);
        BuyFinancingResponseBody body = new BuyFinancingResponseBody();
        List<BuyFinancingResponseDetail> details = FinancingConvert.convertBuyFinancingResponseDetail(infos, iso);
        body.setDetails(details);
        if (!details.isEmpty()) {
            body.setBatchSeqId(details.get(0).getBatchSeqId());
        }
        result.setBody(body);
        return result;
    }

    public static RedeemFinancingResponse convertRedeem(List<FinancingInfo> infos, String iso) {
        RedeemFinancingResponse result = new RedeemFinancingResponse();
        EBHeader header = new EBHeader();
        header.setResponseTime((long)LocalDateTime.now().getNano());
        result.setHeader(header);
        RedeemFinancingResponseBody body = new RedeemFinancingResponseBody();
        List<BuyFinancingResponseDetail> details = FinancingConvert.convertBuyFinancingResponseDetail(infos, iso);
        body.setDetails(details);
        if (!details.isEmpty()) {
            body.setBatchSeqId(details.get(0).getBatchSeqId());
            body.setBatchBizNo(details.get(0).getBatchSeqId());
        }
        result.setBody(body);
        return result;
    }

    public static List<BuyFinancingResponseDetail> convertBuyFinancingResponseDetail(List<FinancingInfo> infos, String iso) {
        ArrayList<BuyFinancingResponseDetail> details = new ArrayList<BuyFinancingResponseDetail>(16);
        for (FinancingInfo info : infos) {
            BuyFinancingResponseDetail detail = new BuyFinancingResponseDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            detail.setBatchSeqId(info.getBatchSeqId());
            detail.setCurrency(iso);
            detail.setEbSeqId(info.getId());
            detail.setEbStatus(EbStatus.convertBankState2EBG((FinancingState)FinancingState.getEnumById((int)info.getStatus())).getName());
            detail.setBankStatus(info.getBankStatus());
            detail.setBankMsg(FinancingConvert.addTitle(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de", (String)"FinancingConvert_0", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getBankMsg()));
            if (FinancingState.FAIL.getId() == info.getStatus().intValue() && !StringUtils.isEmpty((String)info.getBankMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"FinancingConvert_3", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getStatusMsg()) + "\uff0c" + String.format(ResManager.loadKDString((String)"\u539f\u56e0\uff1a%s", (String)"FinancingConvert_4", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getBankMsg()));
            } else if (StringUtils.isEmpty((String)info.getErrorMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"FinancingConvert_3", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getStatusMsg()));
            } else {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\uff1a%1$s,%2$s", (String)"FinancingConvert_5", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getStatusMsg(), info.getErrorMsg()));
            }
            details.add(detail);
        }
        return details;
    }

    public static QueryBuyFinancingResponse convertToResponse(List<FinancingInfo> infos, QueryBuyFinancingRequest request) {
        QueryBuyFinancingResponse response = new QueryBuyFinancingResponse();
        response.setHeader(request.getHeader());
        QueryBuyFinancingResponseBody body = new QueryBuyFinancingResponseBody();
        body.setDetails(FinancingConvert.convertBuyFinancingResponseDetail(infos, request.getHeader().getCurrency()));
        body.setBatchSeqId(request.getBody().getBatchSeqId());
        body.setTotalCount(Integer.valueOf(infos.size()));
        response.setBody(body);
        return response;
    }

    public static QueryRedeemFinancingResponse convertToResponse(List<FinancingInfo> infos, QueryRedeemFinancingRequest request) {
        QueryRedeemFinancingResponse response = new QueryRedeemFinancingResponse();
        response.setHeader(request.getHeader());
        QueryRedeemFinancingResponseBody body = new QueryRedeemFinancingResponseBody();
        body.setDetails(FinancingConvert.convertBuyFinancingResponseDetail(infos, request.getHeader().getCurrency()));
        body.setBatchSeqId(request.getBody().getBatchSeqId());
        body.setTotalCount(Integer.valueOf(infos.size()));
        response.setBody(body);
        return response;
    }

    private static String addTitle(String title, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        return title + "," + content;
    }
}

