/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.atomic.IPayTransfer;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentConvert;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.mock.pay.MockPaymentInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.conf.ParameterImpl;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class MockPayMethod
implements EBServiceMethod<PayRequest, PayResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(MockPayMethod.class);

    public PayResponse executeClientRequest(PayRequest request, EBContext context) {
        Set<List<PaymentInfo>> set;
        List<PaymentInfo> validPaymentInfos;
        List<PaymentInfo> paymentInfos;
        AccessUtils.checkPaymentAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.monitorFeature(" sk_2024_037_012", " aqap_mock_pay_route", "mockPay", "MockPayMethod");
        boolean isBatchRollBack = PaymentUtil.isBatchPayRollBack((EBRequest)request);
        InvalidPaymentResult paymentResult = new InvalidPaymentResult(isBatchRollBack);
        try {
            this.checkStructure(request);
            PaymentUtil.checkExplanationSpecialCharPool((EBRequest)request, paymentResult);
            paymentInfos = PaymentConvert.convertPay(request);
            PaymentUtil.checkInvalidPayments(paymentInfos, paymentResult);
            PaymentUtil.payRouteTrace(paymentInfos);
            PaymentUtil.payPriority(paymentInfos);
            PaymentUtil.preTreatment(paymentInfos, paymentResult);
            PaymentUtil.execCheck(paymentInfos, paymentResult);
            validPaymentInfos = paymentResult.getValidPaymentInfoList(paymentInfos);
            set = PaymentUtil.packagePay(validPaymentInfos);
            PaymentUtil.recountTotalAmount(set);
        }
        catch (IllegalArgumentException | EBServiceException e) {
            throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
        }
        catch (EBDuplicateException e) {
            throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
        }
        long currencyId = this.getCurrencyID(request);
        MockPaymentInfoService.getInstance().insertMockPayment(validPaymentInfos, currencyId);
        EBContext.initParameter();
        ParameterImpl parameter = (ParameterImpl)EBContext.getContext().getParameter();
        parameter.setBankParameter("ip", "");
        parameter.setBankParameter("exchangePort", "0");
        EBContext.getContext().setParameter((IParameter)parameter);
        for (List<PaymentInfo> paymentInfoList : set) {
            boolean errorFlag = false;
            String bankBatchSeqID = paymentInfoList.get(0).getBankBatchSeqID();
            try {
                MDC.put((String)"logger_detail_no", (String)bankBatchSeqID);
                this.logger.infoIndex("log index");
                this.invokePayPack(paymentInfoList);
            }
            catch (EBServiceException e) {
                errorFlag = true;
                this.logger.error("\u8c03\u7528\u5b9e\u73b0\u7c7b\u6253\u5305\u5f02\u5e38", (Throwable)e);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                errorFlag = true;
                this.logger.error("\u6846\u67b6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            MockPaymentInfoService.getInstance().updatePayStatus(bankBatchSeqID, errorFlag);
        }
        return PaymentConvert.convertToResponse(paymentInfos, request);
    }

    private long getCurrencyID(PayRequest request) {
        String bd_currency;
        String extData = request.getHeader().getExtData();
        long bdCurrencyId = 0L;
        JSONObject jsonObject = JSONObject.parseObject((String)extData);
        if (jsonObject.containsKey((Object)"bd_currency") && StringUtils.isNotEmpty((String)(bd_currency = jsonObject.getString("bd_currency")))) {
            try {
                bdCurrencyId = Long.parseLong(bd_currency);
            }
            catch (NumberFormatException e) {
                bdCurrencyId = 0L;
            }
        }
        return bdCurrencyId;
    }

    private void checkStructure(PayRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void invokePayPack(List<PaymentInfo> paymentInfoList) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String className = paymentInfoList.get(0).getImplClassName();
        Class<?> clazz = Class.forName(className);
        IPayTransfer pay = (IPayTransfer)clazz.newInstance();
        BankPayRequest bankPayRequest = new BankPayRequest();
        bankPayRequest.setHeader(this.getHeader(paymentInfoList.get(0)));
        bankPayRequest.setPaymentInfos(paymentInfoList);
        bankPayRequest.setBankBatchSeqID(paymentInfoList.get(0).getBankBatchSeqID());
        bankPayRequest.setTotalCount(paymentInfoList.size());
        bankPayRequest.setTotalAmount(paymentInfoList.get(0).getTotalAmount());
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            String requestStr = pay.pack(bankPayRequest);
            this.logger.info("\u6a21\u62df\u4ed8\u6b3e\u6d4b\u8bd5\u94f6\u884c\u63d0\u4ea4\u62a5\u6587\uff1a\r\n{}", (Object)requestStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private BankHeader getHeader(PaymentInfo info) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(info.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqID());
        header.setLogBizSeqID(info.getBatchSeqID());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("mockPayTest");
        header.setClientVersion("1.0");
        return header;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.PAY.name();
    }
}

