/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.atomic;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentTrace {
    private ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    private GlobalPropertyConfig globalPropertyConfig;

    private void push(String key, String value) {
        String condition = " = ";
        this.push(key, condition, value);
    }

    private void push(String key, String condition, String value) {
        String item = key + condition + value;
        if (this.queue == null) {
            this.queue = new ConcurrentLinkedQueue();
        }
        if (!this.queue.contains(item)) {
            this.queue.offer(item);
        }
    }

    private String getPayRoute() {
        StringBuilder payRoute = new StringBuilder("start -> ");
        if (this.queue == null) {
            this.queue = new ConcurrentLinkedQueue();
        }
        if (!this.queue.isEmpty()) {
            payRoute.append("\r\n");
            while (!this.queue.isEmpty()) {
                payRoute.append(this.queue.poll()).append(" -> ");
                payRoute.append("\r\n");
            }
            payRoute.append("end");
        }
        this.queue.clear();
        return payRoute.toString();
    }

    public void setPayRouteTrace(PaymentInfo paymentInfo) {
        paymentInfo.setPackageKey(paymentInfo.getPackageKey() + this.getPayRoute());
    }

    public void setPayRouteTrace(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        if (StringUtils.isNotEmpty((String)busiImplInfo.getPackageKey())) {
            paymentInfo.setPackageKey(paymentInfo.getPackageKey() + busiImplInfo.getPackageKey());
        }
        this.setPayRouteTrace(paymentInfo);
    }

    public boolean isPay(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.PAY);
    }

    public boolean isPay_for_salary(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.PAY_FOR_SALARY);
    }

    public boolean isPay_for_capital_allocation(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION);
    }

    public boolean isPay_for_linkPay(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.PAY_FOR_LINKPAY);
    }

    public boolean isPay_for_agentPay(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.PAY_FOR_AGENTPAY);
    }

    public boolean isPay_for_overseaPay(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.OVERSEA_PAY);
    }

    public boolean isIncome(PaymentInfo paymentInfo) {
        return this.assertSubBizType(paymentInfo, PayTypeEnum.INCOME);
    }

    private boolean assertSubBizType(PaymentInfo paymentInfo, PayTypeEnum payTypeEnum) {
        boolean result = payTypeEnum.getName().equalsIgnoreCase(paymentInfo.getSubBizType());
        if (result) {
            this.push(PayRouteEnum.BIZ_TYPE.getDesc(), payTypeEnum.getDesc());
        }
        return result;
    }

    public boolean assertSubBizType(PaymentInfo paymentInfo, String assertValue) {
        boolean result = assertValue.equalsIgnoreCase(paymentInfo.getSubBizType());
        if (result) {
            this.push(PayRouteEnum.BIZ_TYPE.getDesc(), assertValue);
        }
        return result;
    }

    public boolean assertCurrency(String currency, String assertValue) {
        boolean result;
        boolean bl = result = StringUtils.isNotEmpty((String)currency) && StringUtils.isNotEmpty((String)assertValue) && assertValue.equalsIgnoreCase(currency);
        if (result) {
            this.addRoute(false, PayRouteEnum.CURRENCY.getDesc(), assertValue);
        }
        return result;
    }

    public boolean assertISOCurrency(String iso_currency, String assertValue) {
        boolean result;
        boolean bl = result = StringUtils.isNotEmpty((String)iso_currency) && StringUtils.isNotEmpty((String)assertValue) && assertValue.equalsIgnoreCase(iso_currency);
        if (result) {
            this.addRoute(false, PayRouteEnum.CURRENCY.getDesc(), assertValue);
        }
        return result;
    }

    public boolean isMerge(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2Merge();
        this.push(PayRouteEnum.MERGE.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isSameCity(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2SameCity();
        this.push(PayRouteEnum.SAME_CITY.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isSameBank(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2SameBank();
        this.push(PayRouteEnum.SAME_BANK.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isIndividual(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2Individual();
        this.push(PayRouteEnum.INDIVIDUAL.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isUrgent(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2Urgent();
        this.push(PayRouteEnum.URGENT.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isForce(PaymentInfo paymentInfo) {
        boolean result = paymentInfo.is2Urgent();
        this.push(PayRouteEnum.FORCE.getDesc(), String.valueOf(result));
        return result;
    }

    public boolean isSalaryUseCN(PaymentInfo paymentInfo) {
        boolean result = UseConvertor.isSalary((PaymentInfo)paymentInfo);
        if (result) {
            this.push(PayRouteEnum.USE_CN.getDesc(), paymentInfo.getUseCN());
        }
        return result;
    }

    public boolean isTransferUseCN(PaymentInfo paymentInfo) {
        boolean result = UseConvertor.isTransfer((PaymentInfo)paymentInfo);
        if (result) {
            this.push(PayRouteEnum.USE_CN.getDesc(), paymentInfo.getUseCN());
        }
        return result;
    }

    public boolean isTransferUpUseCN(PaymentInfo paymentInfo) {
        boolean result = UseConvertor.isTransUp((PaymentInfo)paymentInfo);
        if (result) {
            this.push(PayRouteEnum.USE_CN.getDesc(), paymentInfo.getUseCN());
        }
        return result;
    }

    public boolean isTransferDownUseCN(PaymentInfo paymentInfo) {
        boolean result = UseConvertor.isTransDown((PaymentInfo)paymentInfo);
        if (result) {
            this.push(PayRouteEnum.USE_CN.getDesc(), paymentInfo.getUseCN());
        }
        return result;
    }

    public boolean isReimUseCN(PaymentInfo paymentInfo) {
        boolean result = UseConvertor.isReim((PaymentInfo)paymentInfo);
        if (result) {
            this.push(PayRouteEnum.USE_CN.getDesc(), paymentInfo.getUseCN());
        }
        return result;
    }

    public boolean assertAccountConfig(String key, String assertValue, String accNo) {
        return this.assertBusinessConfig(key, assertValue, true, accNo);
    }

    public boolean assertBusinessConfig(String key, String assertValue) {
        return this.assertBusinessConfig(key, assertValue, false, "");
    }

    private boolean assertBusinessConfig(String key, String assertValue, boolean isAccNo, String accNo) {
        boolean result;
        if (EBContext.getContext().isUnitTest()) {
            return true;
        }
        PropertyConfigItem configItem = this.getPropertyConfigItem(key);
        if (configItem == null) {
            return false;
        }
        String mlKey = configItem.getMlName().getDescription();
        String mlValue = isAccNo ? configItem.getCurrentValueWithObjectID(accNo) : configItem.getCurrentValue();
        boolean bl = result = StringUtils.isNotEmpty((String)assertValue) && assertValue.equalsIgnoreCase(mlValue);
        if (result) {
            List sourceCNNames = configItem.getMlSourceNames();
            List sourceValues = configItem.getSourceValues();
            if (sourceCNNames != null && sourceValues != null) {
                for (int i = 0; i < sourceValues.size(); ++i) {
                    if (!assertValue.equalsIgnoreCase((String)sourceValues.get(i))) continue;
                    mlValue = ((MultiLangEnumBridge)sourceCNNames.get(i)).getDescription();
                }
            }
            if (isAccNo) {
                this.push(PayRouteEnum.ACCOUNT_CONFIG.getDesc() + "\uff1a" + mlKey, mlValue);
            } else {
                this.push(PayRouteEnum.BUS_CONFIG.getDesc() + "\uff1a" + mlKey, mlValue);
            }
        }
        return result;
    }

    public void addRoute(boolean isBankBusinessConfig, String key, String desc) {
        if (isBankBusinessConfig) {
            PropertyConfigItem configItem = this.getPropertyConfigItem(key);
            if (configItem != null) {
                this.push(PayRouteEnum.BUS_CONFIG.getDesc() + "\uff1a" + configItem.getMlName().getDescription(), desc);
            }
        } else {
            this.push(key, desc);
        }
    }

    public void addRoute(boolean isBankBusinessConfig, String key, String condition, String desc) {
        if (StringUtils.isEmpty((String)condition)) {
            condition = " ";
        }
        if (isBankBusinessConfig) {
            PropertyConfigItem configItem = this.getPropertyConfigItem(key);
            if (configItem != null) {
                this.push(PayRouteEnum.BUS_CONFIG.getDesc() + "\uff1a" + configItem.getMlName().getDescription(), condition, desc);
            }
        } else {
            this.push(key, condition, desc);
        }
    }

    public void setImplClassName(PaymentInfo paymentInfo, String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            paymentInfo.setImplClassName(className);
            this.push(PayRouteEnum.IMPL.getDesc(), className);
            try {
                IPay pay = (IPay)Class.forName(className).newInstance();
                String bankPayCode = pay.getBizCode();
                this.push(PayRouteEnum.BANK_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankPayCode) ? "" : bankPayCode);
                this.setQueryImplClassName(paymentInfo, pay.defaultQueryClass().getName());
            }
            catch (Exception e) {
                EBExceiptionUtil.serviceException((String)("PayImpl = " + className + " is not found"), (Throwable)e);
            }
        }
    }

    private void setQueryImplClassName(PaymentInfo paymentInfo, String className) {
        paymentInfo.setQueryImplClassName(className);
        this.push(PayRouteEnum.QUERY_IMPL.getDesc(), className);
        try {
            AbstractQueryPayImpl queryPay = (AbstractQueryPayImpl)Class.forName(className).newInstance();
            String bankQueryPayCode = queryPay.getBizCode();
            this.push(PayRouteEnum.BANK_QUERY_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankQueryPayCode) ? "" : bankQueryPayCode);
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((String)("QueryPayImpl = " + className + " is not found"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevImplClassName(PaymentInfo paymentInfo, String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            paymentInfo.setImplClassName(className);
            try {
                PaymentUtil.setReDevResult(paymentInfo);
                IPay pay = (IPay)Class.forName(className).newInstance();
                this.push(PayRouteEnum.IMPL.getDesc(), pay.getBizDesc());
                String bankPayCode = pay.getBizCode();
                this.push(PayRouteEnum.BANK_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankPayCode) ? "" : bankPayCode);
                this.setDevQueryImplClassName(paymentInfo, pay.defaultQueryClass().getName());
            }
            catch (Exception e) {
                EBExceiptionUtil.serviceException((String)("PayImpl = " + className + " is not found"), (Throwable)e);
            }
            finally {
                PaymentUtil.clearReDevResult();
            }
        }
    }

    private void setDevQueryImplClassName(PaymentInfo paymentInfo, String className) {
        paymentInfo.setQueryImplClassName(className);
        try {
            AbstractQueryPayImpl queryPay = (AbstractQueryPayImpl)Class.forName(className).newInstance();
            this.push(PayRouteEnum.QUERY_IMPL.getDesc(), queryPay.getBizDesc());
            String bankQueryPayCode = queryPay.getBizCode();
            this.push(PayRouteEnum.BANK_QUERY_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankQueryPayCode) ? "" : bankQueryPayCode);
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((String)("QueryPayImpl = " + className + " is not found"), (Throwable)e);
        }
    }

    private PropertyConfigItem getPropertyConfigItem(String key) {
        this.globalPropertyConfig = (GlobalPropertyConfig)SpringContextUtil.getBean(GlobalPropertyConfig.class);
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.globalPropertyConfig.getPropertyConfigItem(bankVersionID, key);
    }
}

