/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.priority;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.priority.PayRuleInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class PayPriority {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PayPriority.class);
    private String bankVersionID;
    private String subBizType;
    private BigDecimal amount;
    private String currency;
    private String explanation;
    private String useCn;
    private boolean individual;
    private boolean sameBank;
    private boolean merge;
    private String Impl;
    private String queryPayImpl;
    private Map<String, Map<Object, DynamicObject>> payRuleConfigTMap = new HashMap<String, Map<Object, DynamicObject>>(16);
    private Map<Long, List<PayRuleInfo>> payRuleInfoMap = new HashMap<Long, List<PayRuleInfo>>(16);

    public void setPaymentInfo(PaymentInfo info) {
        this.setBankVersionID(info.getBankVersionID());
        this.setSubBizType(info.getSubBizType());
        this.setAmount(info.getAmount());
        this.setCurrency(info.getIsoCurrencyCode());
        this.setExplanation(info.getExplanation());
        this.setUseCn(info.getUseCN());
        this.setIndividual(info.is2Individual());
        this.setSameBank(info.is2SameBank());
        this.setMerge(info.is2Merge());
        this.setImpl("");
        this.setQueryPayImpl("");
    }

    public void release() {
        this.payRuleConfigTMap.clear();
        this.payRuleInfoMap.clear();
    }

    public boolean match(PaymentInfo info) {
        this.setPaymentInfo(info);
        String entity = "aqap_pay_rule_config";
        String properties = "id,number,group.number,name,enable,bd_interface.bank_code,bd_interface.class_name,sort_num,key,condition,value";
        QFilter filter = QFilter.of((String)"group.number=?", (Object[])new Object[]{this.getBankVersionID()});
        String orderBy = "sort_num asc";
        boolean isMatch = true;
        Map payRuleConfigMap = null;
        if (this.payRuleConfigTMap.containsKey(this.getBankVersionID())) {
            payRuleConfigMap = this.payRuleConfigTMap.get(this.getBankVersionID());
        } else {
            payRuleConfigMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)properties, (QFilter[])filter.toArray(), (String)orderBy);
            this.payRuleConfigTMap.put(this.getBankVersionID(), payRuleConfigMap);
        }
        if (payRuleConfigMap != null && payRuleConfigMap.size() > 0) {
            for (Map.Entry entry : payRuleConfigMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                if (!"1".equalsIgnoreCase(dynamicObject.getString("enable"))) continue;
                Long id = dynamicObject.getLong("id");
                String number = dynamicObject.getString("number");
                List<PayRuleInfo> payRuleInfoList = this.getPayRuleByID(id, dynamicObject.getDynamicObjectCollection("aqap_pay_rule"));
                isMatch = true;
                for (PayRuleInfo payRuleInfo : payRuleInfoList) {
                    if (payRuleInfo.match(this)) continue;
                    isMatch = false;
                    break;
                }
                if (!isMatch) continue;
                PretreatmentTrace pretreatmentTrace = new PretreatmentTrace();
                String msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u53f7\u4e3a%1$s\u7684\u5206\u5f55\uff0c\u5339\u914d\u5230\u7f16\u53f7\u4e3a%2$s\u7684\u4ed8\u6b3e\u63a5\u53e3\u89c4\u5219\u3002", (String)"PayPriority_0", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getDetailSeqID(), number);
                pretreatmentTrace.addRoute(false, "", "", msg);
                for (PayRuleInfo payRuleInfo : payRuleInfoList) {
                    pretreatmentTrace.addRoute(false, payRuleInfo.getKey(), payRuleInfo.getCondition(), payRuleInfo.getValue());
                }
                String className = dynamicObject.getString("bd_interface.class_name");
                this.setImpl(className);
                pretreatmentTrace.setImplClassName(info, className);
                pretreatmentTrace.setPayRouteTrace(info);
                this.logger.info(msg);
            }
        }
        return isMatch;
    }

    private List<PayRuleInfo> getPayRuleByID(Long id, DynamicObjectCollection dynamicObjectCollection) {
        if (this.payRuleInfoMap.containsKey(id)) {
            return this.payRuleInfoMap.get(id);
        }
        ArrayList<PayRuleInfo> payRuleInfoList = new ArrayList<PayRuleInfo>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String key = dynamicObject.getString("key");
            String condition = dynamicObject.getString("condition");
            String value = dynamicObject.getString("value");
            PayRuleInfo payRuleInfo = new PayRuleInfo(key, condition, value);
            payRuleInfoList.add(payRuleInfo);
        }
        this.payRuleInfoMap.put(id, payRuleInfoList);
        return payRuleInfoList;
    }

    public String getImpl() {
        return this.Impl;
    }

    public void setImpl(String impl) {
        this.Impl = impl;
    }

    public String getBankVersionID() {
        return this.bankVersionID;
    }

    public void setBankVersionID(String bankVersionID) {
        this.bankVersionID = bankVersionID;
    }

    public String getQueryPayImpl() {
        return this.queryPayImpl;
    }

    public void setQueryPayImpl(String queryPayImpl) {
        this.queryPayImpl = queryPayImpl;
    }

    public String getSubBizType() {
        return this.subBizType;
    }

    public void setSubBizType(String subBizType) {
        this.subBizType = subBizType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getUseCn() {
        return this.useCn;
    }

    public void setUseCn(String useCn) {
        this.useCn = useCn;
    }

    public boolean isIndividual() {
        return this.individual;
    }

    public void setIndividual(boolean individual) {
        this.individual = individual;
    }

    public boolean isSameBank() {
        return this.sameBank;
    }

    public void setSameBank(boolean sameBank) {
        this.sameBank = sameBank;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }
}

