/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.schedule;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.AttachmentUploadTask;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AttachmentUploadJob
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        PayAttachmentService payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
        List attachments = payAttachmentService.findAttachmentsByStatusId((List)Lists.newArrayList((Object[])new Integer[]{AttachmentState.FAIL.getId(), AttachmentState.UNKNOWN.getId()}));
        if (CollectionUtil.isEmpty((Collection)attachments)) {
            return;
        }
        Map<String, List<PayAttachment>> listMap = attachments.stream().collect(Collectors.groupingBy(PayAttachment::getBankBatchSeqID));
        for (Map.Entry<String, List<PayAttachment>> entry : listMap.entrySet()) {
            List<PayAttachment> lists = entry.getValue();
            String retryCount = lists.get(0).getReversed1();
            if (StringUtils.isEmpty((String)retryCount)) {
                retryCount = "1";
            }
            if (Integer.parseInt(retryCount) > 30) continue;
            int count = Integer.parseInt(retryCount) + 1;
            lists.forEach(payAttachment -> payAttachment.setReversed1(String.valueOf(count)));
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(lists.get(0).getCustomID()).logRequestSeqID(Sequence.genSequence()).bizName("attachmentUpload").subBizName("attachmentUpload").bankVersionID(lists.get(0).getBankVersionID()).bankLoginID(lists.get(0).getBankLoginID()).logBizSeqID(Sequence.genSequence()).bizSeqID(Sequence.genSequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(Sequence.genSequence()).loggerDetailNo(Sequence.genSequence()).loggerBankNo(Sequence.genSequence()).build();
            BankAcnt bankAcnt = new BankAcnt();
            context.setBankAcnt(bankAcnt);
            EBContext.setContext((EBContext)context);
            BankAttachmentRequest bankAttachmentRequest = new BankAttachmentRequest();
            bankAttachmentRequest.setPayAttachments(lists);
            String taskID = "";
            try {
                taskID = EBThreadPools.createBizTask(context);
            }
            catch (Throwable e) {
                this.logger.monitorInfo("createBizTask fail :" + e.getMessage());
            }
            AttachmentUploadTask attachmentUploadTask = new AttachmentUploadTask(bankAttachmentRequest, context);
            attachmentUploadTask.setTaskId(taskID);
            EBThreadPools.getAttachmentUploadThreadPool(context.getCustomID(), context.getBankLoginID()).submit((Callable)((Object)attachmentUploadTask));
        }
    }
}

