/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.file.atomic.IUpload;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class AttachmentUploadTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadTask.class);
    private BankAttachmentRequest bankAttachmentRequest;
    private EBContext context;
    private static final String REQUEST_SEQ_ID_KEY = "requestSeqID";
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";
    private static final String CUSTOMER_ID = "customerID";
    private static final String BANK_VERSION_ID = "bankVersionID";

    public AttachmentUploadTask(BankAttachmentRequest bankAttachmentRequest, EBContext context) {
        this.bankAttachmentRequest = bankAttachmentRequest;
        this.context = context;
    }

    public Object doBiz() {
        BankAttachmentResponse bankAttachmentResponse = this.submitUpload(this.bankAttachmentRequest, this.context);
        return bankAttachmentResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private BankAttachmentResponse submitUpload(BankAttachmentRequest bankAttachmentRequest, EBContext context) {
        block12: {
            payAttachments = bankAttachmentRequest.getPayAttachments();
            attachment = payAttachments.get(0);
            EBContext.setContext((EBContext)context);
            payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
            MDCUtil.clearBankMDC();
            MDCUtil.initMDC((EBContext)context);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            MDC.put((String)"requestSeqID", (String)context.getRequestSeqID());
            MDC.put((String)"bizSeqID", (String)context.getBizSeqID());
            MDC.put((String)"customerID", (String)context.getCustomID());
            MDC.put((String)"bizName", (String)context.getBizName());
            MDC.put((String)"bankVersionID", (String)context.getBankVersionID());
            this.logger.infoIndex(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u9644\u4ef6\u4e0a\u4f20\u4e1a\u52a1\u5904\u7406,%s", (String)"AttachmentUploadTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), new Object[]{context.getLogger_batch_no()}));
            upload = (IUpload)BankBundleManager.getInstance().getImplByClassName(attachment.getBankVersionID(), IUpload.class, attachment.getImplClassName());
            this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", (Object)attachment.getImplClassName());
            access = null;
            try {
                EBContext.initParameter();
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                bankAttachmentResponse = upload.upload(bankAttachmentRequest);
                if (bankAttachmentResponse == null || !CollectionUtil.isNotEmpty(bankAttachmentResponse.getPayAttachments())) break block12;
                payAttachmentService.updateAll(bankAttachmentResponse.getPayAttachments());
            }
            catch (Throwable e) {
                block13: {
                    try {
                        this.logger.error("\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38", e);
                        if (!CollectionUtil.isNotEmpty(payAttachments)) break block13;
                        for (PayAttachment payAttachment : payAttachments) {
                            payAttachment.setStatus(Integer.valueOf(AttachmentState.FAIL.getId()));
                            payAttachment.setStatusName(AttachmentState.FAIL.getEnName());
                            payAttachment.setStatusMsg(AttachmentState.FAIL.getCnName());
                            error = e.getMessage();
                            if (StringUtils.isNotEmpty((String)error) && error.length() > 255) {
                                error = error.substring(0, 255);
                            }
                            payAttachment.setBankMsg(error);
                        }
                        payAttachmentService.updateAll(payAttachments);
                    }
                    catch (Throwable var13_18) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        list = payAttachments.stream().filter((Predicate<PayAttachment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$submitUpload$0(kd.ebg.egf.common.model.file.PayAttachment ), (Lkd/ebg/egf/common/model/file/PayAttachment;)Z)()).collect(Collectors.toList());
                        if (CollectionUtil.isNotEmpty(list)) {
                            paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
                            paymentInfo = paymentInfoRepository.findByBankDetailSeqID(((PayAttachment)list.get(0)).getBankDetailSeqID());
                            sb = new StringBuilder();
                            sb.append(paymentInfo.getBankMsg());
                            tips = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u94f6\u884c\u5931\u8d25\uff0c\u8bf7\u4e0e\u94f6\u884c\u8054\u7cfb\u786e\u8ba4\u5931\u8d25\u9644\u4ef6\u5185\u5bb9\u6216\u901a\u8fc7\u94f6\u4f01\u65e5\u5fd7\u786e\u8ba4\u9644\u4ef6\u4f20\u8f93\u60c5\u51b5", (String)"AttachmentUploadTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
                            if (StringUtils.isNotEmpty((String)paymentInfo.getBankMsg()) && !paymentInfo.getBankMsg().contains(tips)) {
                                sb.append(",");
                                sb.append(tips);
                            }
                            paymentInfo.setBankMsg(sb.toString());
                            paymentInfoRepository.updateAll((List)Lists.newArrayList((Object[])new PaymentInfo[]{paymentInfo}));
                        }
                        throw var13_18;
                    }
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                list = payAttachments.stream().filter((Predicate<PayAttachment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$submitUpload$0(kd.ebg.egf.common.model.file.PayAttachment ), (Lkd/ebg/egf/common/model/file/PayAttachment;)Z)()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(list)) {
                    paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
                    paymentInfo = paymentInfoRepository.findByBankDetailSeqID(((PayAttachment)list.get(0)).getBankDetailSeqID());
                    sb = new StringBuilder();
                    sb.append(paymentInfo.getBankMsg());
                    tips = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u94f6\u884c\u5931\u8d25\uff0c\u8bf7\u4e0e\u94f6\u884c\u8054\u7cfb\u786e\u8ba4\u5931\u8d25\u9644\u4ef6\u5185\u5bb9\u6216\u901a\u8fc7\u94f6\u4f01\u65e5\u5fd7\u786e\u8ba4\u9644\u4ef6\u4f20\u8f93\u60c5\u51b5", (String)"AttachmentUploadTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
                    if (StringUtils.isNotEmpty((String)paymentInfo.getBankMsg()) && !paymentInfo.getBankMsg().contains(tips)) {
                        sb.append(",");
                        sb.append(tips);
                    }
                    paymentInfo.setBankMsg(sb.toString());
                    paymentInfoRepository.updateAll((List)Lists.newArrayList((Object[])new PaymentInfo[]{paymentInfo}));
                } else {
                    ** GOTO lbl94
                }
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        list = payAttachments.stream().filter((Predicate<PayAttachment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$submitUpload$0(kd.ebg.egf.common.model.file.PayAttachment ), (Lkd/ebg/egf/common/model/file/PayAttachment;)Z)()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
            paymentInfo = paymentInfoRepository.findByBankDetailSeqID(((PayAttachment)list.get(0)).getBankDetailSeqID());
            sb = new StringBuilder();
            sb.append(paymentInfo.getBankMsg());
            tips = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u94f6\u884c\u5931\u8d25\uff0c\u8bf7\u4e0e\u94f6\u884c\u8054\u7cfb\u786e\u8ba4\u5931\u8d25\u9644\u4ef6\u5185\u5bb9\u6216\u901a\u8fc7\u94f6\u4f01\u65e5\u5fd7\u786e\u8ba4\u9644\u4ef6\u4f20\u8f93\u60c5\u51b5", (String)"AttachmentUploadTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)paymentInfo.getBankMsg()) && !paymentInfo.getBankMsg().contains(tips)) {
                sb.append(",");
                sb.append(tips);
            }
            paymentInfo.setBankMsg(sb.toString());
            paymentInfoRepository.updateAll((List)Lists.newArrayList((Object[])new PaymentInfo[]{paymentInfo}));
        }
        bankAttachmentResponse = new BankAttachmentResponse();
        bankAttachmentResponse.setPayAttachments(payAttachments);
        return bankAttachmentResponse;
    }

    private static /* synthetic */ boolean lambda$submitUpload$0(PayAttachment payAttachment) {
        return payAttachment.getStatus().equals(AttachmentState.FAIL.getId());
    }
}

