/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.financing.atomic.IBuyFinancing;
import kd.ebg.aqap.business.financing.atomic.IRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBLoginAccessException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BankFinancingTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankFinancingTask.class);
    private BankFinancingRequest request;
    private EBContext context;

    public BankFinancingTask(BankFinancingRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankFinancingResponse ebBankCurAndFixedResponse = this.submit(this.request, this.context);
        return ebBankCurAndFixedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankFinancingResponse submit(BankFinancingRequest request, EBContext context) {
        EBBankFinancingResponse response;
        FEPAccess access;
        List<FinancingInfo> result;
        FinancingService financingService;
        block21: {
            List infos;
            String bankVersion;
            block20: {
                bankVersion = request.getInfos().get(0).getBankVersionID();
                EBContext.setContext((EBContext)context);
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u7406\u8d22\u4e1a\u52a1\u5904\u7406,{}", (Object)context.getBizSeqID());
                this.logger.info("\u5f00\u59cb\u7406\u8d22\u4e1a\u52a1,\u603b\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)request.getInfos().size());
                infos = request.getInfos();
                if (infos.isEmpty()) {
                    return null;
                }
                financingService = FinancingService.getInstance();
                result = null;
                access = null;
                EBContext.initParameter();
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                infos = financingService.compareAndStateState(infos, FinancingState.PACKAGED, FinancingState.SUBMITTING);
                if (!Objects.isNull(infos) && !infos.isEmpty()) break block20;
                this.logger.info("\u7406\u8d22\u72b6\u6001\u4fee\u6539\u4e3a\u63d0\u4ea4\u4e2d\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5176\u4ed6\u8282\u70b9\u5904\u7406\u8fc7\u7684\u8bf7\u6c42.bankBatchSeqId:{}", (Object)request.getBatchSeqId());
                EBBankFinancingResponse eBBankFinancingResponse = null;
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                return eBBankFinancingResponse;
            }
            try {
                Object financing;
                request.setInfos(infos);
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                if ("buyFinancing".equalsIgnoreCase(request.getHeader().getBizType())) {
                    financing = (IBuyFinancing)BankBundleManager.getInstance().getImpl(bankVersion, IBuyFinancing.class, (Object)request);
                    response = financing.buyFinancing(request);
                } else {
                    financing = (IRedeemFinancing)BankBundleManager.getInstance().getImpl(bankVersion, IRedeemFinancing.class, (Object)request);
                    response = financing.redeemFinancing(request);
                }
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                    Throwable t = EBContext.getContext().getThrowableAfterSend();
                    this.logger.error("\u7406\u8d22\u4e92\u8f6c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", t);
                    if (t instanceof EBServiceException) {
                        if (((EBServiceException)t).getErrorCode().equalsIgnoreCase("ProxyCreateConnectionException")) {
                            FinancingUtil.setState(request.getInfos(), FinancingState.FAIL, t.getMessage(), "", "");
                        } else if (((EBServiceException)t).getErrorCode().equalsIgnoreCase("ProxyConnectionException")) {
                            FinancingUtil.setState(request.getInfos(), FinancingState.UNKNOWN, t.getMessage(), "", "");
                        } else {
                            FinancingUtil.setState(request.getInfos(), FinancingState.UNKNOWN, ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u5177\u4f53\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u6267\u884c\u7ed3\u679c\u3002", (String)"BankFinancingTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                        }
                    } else {
                        FinancingUtil.setState(request.getInfos(), FinancingState.UNKNOWN, ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u5177\u4f53\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u6267\u884c\u7ed3\u679c\u3002", (String)"BankFinancingTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                    }
                    result = request.getInfos();
                    break block21;
                }
                Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankFinancingTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (response == null) break block21;
                Preconditions.checkState((boolean)Objects.nonNull(response.getInfos()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u7406\u8d22\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankFinancingTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                result = response.getInfos();
            }
            catch (Exception e) {
                try {
                    this.logger.error("\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    if (e instanceof EBLoginAccessException) {
                        FinancingUtil.setState(request.getInfos(), FinancingState.PACKAGED, "", "", "");
                        this.logger.error("\u72b6\u6001\u9000\u56de\"\u5df2\u6253\u5305\"\u72b6\u6001");
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BankFinancingTask_3", (String)"ebg-aqap-business", (Object[])new Object[0]);
                        if (!StringUtils.isEmpty((String)e.getMessage())) {
                            errorMsg = errorMsg + "," + e.getMessage();
                        }
                        FinancingUtil.setState(request.getInfos(), FinancingState.FAIL, errorMsg, "", "");
                        for (FinancingInfo info : request.getInfos()) {
                            info.setBackErrorMsg(e.getMessage());
                        }
                    }
                    result = request.getInfos();
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        if (CollectionUtil.isNotEmpty(result)) {
            financingService.save(result);
        }
        response = new EBBankFinancingResponse();
        response.setHeader(request.getHeader());
        response.setBatchSeqId(request.getBatchSeqId());
        response.setInfos(request.getInfos());
        return response;
    }
}

