/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.payment.company;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.SzdbNewParser;
import kd.ebg.aqap.banks.pab.dc.services.SzdbNewProvinceCode;
import kd.ebg.aqap.banks.pab.dc.services.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.entity.settleBankAccNo.SettleBankAccNoEntity;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"4004", (String)"PayImpl_3", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u5e10\u3001\u884c\u5916\u8f6c\u5e10", (String)"PayImpl_4", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isCompany(info) || this.isIndividual(info);
    }

    public String pack(BankPayRequest request) {
        String sysFlag;
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f01\u4e1a\u5e10\u6237\u8d44\u91d1\u5212\u8f6c[4004]\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PayImpl_5", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element Result = new Element("Result");
        String useEx = paymentInfo.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            useEx = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)useEx);
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        useEx = StringUtils.substringChinese((String)useEx, (String)RequestContextUtils.getCharset(), (int)60);
        JDomUtils.addChild((Element)Result, (String)"ThirdVoucher", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)Result, (String)"CstInnerFlowNo", (String)"");
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Result, (String)"OutAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Result, (String)"OutAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Result, (String)"OutAcctAddr", (String)paymentInfo.getBankAddress());
        boolean isSuperSinglePay = BankBusinessConfig.isSuperSinglePay();
        SettleBankAccNoEntity settleBankAccNoEntity = this.getSettleBankAccNoEntity(isSuperSinglePay, paymentInfo.getIncomeBankName());
        if (settleBankAccNoEntity == null) {
            JDomUtils.addChild((Element)Result, (String)"InAcctBankNode", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)Result, (String)"InAcctRecCode", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)Result, (String)"InAcctBankName", (String)paymentInfo.getIncomeBankName());
        } else {
            JDomUtils.addChild((Element)Result, (String)"InAcctBankNode", (String)settleBankAccNoEntity.getSettleAccno());
            JDomUtils.addChild((Element)Result, (String)"InAcctRecCode", (String)settleBankAccNoEntity.getSettleAccno());
            JDomUtils.addChild((Element)Result, (String)"InAcctBankName", (String)settleBankAccNoEntity.getBankKey());
        }
        JDomUtils.addChild((Element)Result, (String)"InAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Result, (String)"InAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Result, (String)"InAcctProvinceCode", (String)SzdbNewProvinceCode.getprovinceCode(paymentInfo.getIncomeProvince()));
        JDomUtils.addChild((Element)Result, (String)"InAcctCityName", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)Result, (String)"TranAmount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Result, (String)"AmountCode", (String)"");
        JDomUtils.addChild((Element)Result, (String)"UseEx", (String)useEx);
        JDomUtils.addChild((Element)Result, (String)"UnionFlag", (String)(paymentInfo.is2SameBank() ? "1" : "0"));
        String string = sysFlag = paymentInfo.is2Urgent() ? "Y" : "N";
        if (isSuperSinglePay) {
            sysFlag = "S";
        }
        JDomUtils.addChild((Element)Result, (String)"SysFlag", (String)sysFlag);
        JDomUtils.addChild((Element)Result, (String)"AddrFlag", (String)(paymentInfo.is2SameCity() ? "1" : "2"));
        JDomUtils.addChild((Element)Result, (String)"RealFlag", (String)(paymentInfo.getForce() != false ? "1" : "2"));
        JDomUtils.addChild((Element)Result, (String)"MainAcctNo", (String)"");
        JDomUtils.addChild((Element)Result, (String)"Mobile", (String)paymentInfo.getMobiles());
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(Sequence.genSequence(), "4004", xmlStr);
    }

    private SettleBankAccNoEntity getSettleBankAccNoEntity(boolean isSuperSinglePay, String bankName) {
        if (isSuperSinglePay && StringUtils.isNotEmpty((String)bankName)) {
            return ((SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class)).matchByKey(bankName);
        }
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        SzdbNewParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

