/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EActBalQry");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        String accNo = bankBalanceRequest.getAcnt().getAccNo();
        Element root = Packer.buildHead("B2EActBalQry", null);
        Element Map2 = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)accNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String s) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element activeList = JDomUtils.getChildElement((Element)resBody, (String)"List");
        List list = activeList.getChildren("Map");
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < list.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element record = (Element)list.get(i);
            String returnCode = record.getChildTextTrim("ReturnCode");
            if (!"000000".equals(returnCode)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%1$s,%2$s", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), returnCode, record.getChildTextTrim("ReturnMsg")));
            }
            this.setBankCurrency(balanceInfo, rqst.getBankCurrency(), record.getChildText("Currency"));
            balanceInfo.setBankAcnt(rqst.getAcnt());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            this.setCurrentBalance(balanceInfo, record.getChildText("Balance"));
            this.setAvailableBalance(balanceInfo, record.getChildText("AvailBal"));
            infos.add(balanceInfo);
        }
        ebBankBalanceResponse.setBalances(infos);
        return ebBankBalanceResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }
}

