/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.payment.batch;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.payment.batch.QryTransferBatchImpl;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBParser;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.banks.glb.dc.services.utils.HttpSendAndRecUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.entity.settleBankAccNo.SettleBankAccNoEntity;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TransferBatchImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TransferBatchImpl.class);
    private final String SERVICE_QUERY_BATCH_CODE = "CBE020110";
    private final String SERVICE_BATCH_CODE = "CBE020111";

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryTransferBatchImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        logger.info("#################\u83b7\u53d6\u94f6\u884c\u6279\u6b21\u6d41\u6c34\u53f7#################");
        String batchNo = HttpSendAndRecUtils.sendAndRecv(this.createQueryBatchPacker(paymentInfos));
        logger.info("#################\u6784\u5efa\u6279\u91cf\u4ed8\u6b3e\u62a5\u6587#################");
        return this.createBatchPacker(paymentInfos, batchNo);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element ebank_root = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ebank_root.getChild("head");
        Element body = ebank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        String orderFlowNo = JDomUtils.getChildTextTrim((Element)head, (String)"orderFlowNo");
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[0], (String)"orderFlowNo", (String)orderFlowNo);
        if (!"000000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String orderState = body.getChildTextTrim("orderState");
        String errorCode = body.getChildTextTrim("errorCode");
        String errorMessage = body.getChildTextTrim("errorMessage");
        if ("90".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"TransferBatchImpl_0", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        } else if ("99".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)errorMessage);
        } else if ("50".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u6842\u6797\u94f6\u884c\u63a5\u6536\u4e86\u8f6c\u8d26\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\uff01", (String)"TransferBatchImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private String createBatchPacker(PaymentInfo[] paymentInfos, String batchNo) {
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("CBE020111"));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getBatchRequestBody(paymentInfos, batchNo));
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
        return requestXml;
    }

    private Element getBatchRequestBody(PaymentInfo[] paymentInfos, String batchNo) {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)batchNo);
        Element list = new Element("list");
        JDomUtils.addChild((Element)body, (Element)list);
        for (PaymentInfo pInfo : paymentInfos) {
            Element row = new Element("row");
            JDomUtils.addChild((Element)list, (Element)row);
            JDomUtils.addChild((Element)row, (String)"serialNo", (String)pInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)pInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)pInfo.getIncomeAccName());
            boolean urgent = pInfo.getUrgent();
            String recAccountOpenBank = pInfo.getIncomeBankName();
            String unionBankNo = pInfo.getIncomeCnaps();
            if (urgent) {
                JDomUtils.addChild((Element)row, (String)"rmtType", (String)"1");
                SettleBankAccNoEntity settleBankAccNoEntity = TransferBatchImpl.getSettNo(pInfo.getIncomeBankName());
                if (settleBankAccNoEntity != null) {
                    unionBankNo = settleBankAccNoEntity.getSettleAccno();
                    recAccountOpenBank = settleBankAccNoEntity.getBankKey();
                }
            } else {
                JDomUtils.addChild((Element)row, (String)"rmtType", (String)"0");
            }
            JDomUtils.addChild((Element)row, (String)"recAccountOpenBank", (String)recAccountOpenBank);
            JDomUtils.addChild((Element)row, (String)"unionBankNo", (String)unionBankNo);
            JDomUtils.addChild((Element)row, (String)"payAmount", (String)pInfo.getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"payUse", (String)pInfo.getExplanation());
            JDomUtils.addChild((Element)row, (String)"businessCode", (String)"020104");
            JDomUtils.addChild((Element)row, (String)"currencyType", (String)pInfo.getCurrency());
            if (pInfo.is2SameBank()) {
                JDomUtils.addChild((Element)row, (String)"recBankType", (String)"0");
            } else {
                JDomUtils.addChild((Element)row, (String)"recBankType", (String)"1");
            }
            if (pInfo.is2Individual()) {
                JDomUtils.addChild((Element)row, (String)"pubPriFlag", (String)"1");
                continue;
            }
            JDomUtils.addChild((Element)row, (String)"pubPriFlag", (String)"0");
        }
        return body;
    }

    public static SettleBankAccNoEntity getSettNo(String incomeBankName) {
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        SettleBankAccNoEntity settleBankAccNoEntity = settBankKeyWordsRepository.matchSettleBankByKey(incomeBankName);
        return settleBankAccNoEntity;
    }

    private String createQueryBatchPacker(PaymentInfo[] paymentInfos) {
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("CBE020110"));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getQueryBatchRequestBody(paymentInfos[0]));
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
        return requestXml;
    }

    private Element getQueryBatchRequestBody(PaymentInfo paymentInfo) {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)(paymentInfo.getTotalCount() + ""));
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)paymentInfo.getTotalAmount().toString());
        JDomUtils.addChild((Element)body, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAccountName", (String)paymentInfo.getAccName());
        return body;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE020110 & CBE020111";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

