/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBParser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GLBTransferParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GLBTransferParser.class);

    public static void parseTransfer(PaymentInfo[] paymentInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ebank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ebank_root.getChild("head");
        Element body = ebank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        String orderFlowNo = JDomUtils.getChildTextTrim((Element)head, (String)"orderFlowNo");
        PaymentInfoSysFiled.set((PaymentInfo[])paymentInfos, (String)"orderFlowNo", (String)orderFlowNo);
        if (!"000000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            logger.info("\u5931\u8d25\u5230\u7684\u62a5\u6587\u4fe1\u606f\u4e3a\uff1a" + rspStr);
            return;
        }
        String orderState = body.getChildTextTrim("orderState");
        String chargeFee = body.getChildTextTrim("chargeFee");
        if ("90".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)orderState, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f\uff0c\u624b\u7eed\u8d39\uff1a%s\u3002", (String)"GLBTransferParser_4", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), chargeFee));
        } else if ("99".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"GLBTransferParser_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        } else if ("50".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u6842\u6797\u94f6\u884c\u63a5\u6536\u4e86\u8f6c\u8d26\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\uff01", (String)"GLBTransferParser_2", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"GLBTransferParser_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        }
    }
}

