/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jshb.dc.transfer.salary;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jshb.dc.utils.ParserUtil;
import kd.ebg.aqap.banks.jshb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public EBBankPayResponse parseQueryPay(BankPayRequest bankPayRequest, String rspStr) {
        String content;
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        BankResponse headRsp = ParserUtil.parseResponeCode(root);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (!"0_0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            return new EBBankPayResponse(paymentInfos);
        }
        String file_flag = root.getChild("head").getChildTextTrim("file_flag");
        if ("1".equals(file_flag)) {
            this.logger.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = ParserUtil.getDetailRspRecords(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            this.logger.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] rs = this.parseRecord(content, recordNum, fieldNum);
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < rs.length; ++i) {
            String ACNO = rs[i][1];
            String ACNAME = rs[i][3];
            String AMT = rs[i][5];
            String STAT = rs[i][9];
            String ERR_MSG = rs[i][10];
            String BATCH_NO = rs[i][11];
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(ACNO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("1".equals(STAT) || "5".equals(STAT) || "6".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("F".equals(STAT) || "3".equals(STAT) || "4".equals(STAT) || "8".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("0".equals(STAT) || "2".equals(STAT) || "7".equals(STAT) || "9".equals(STAT) || "A".equals(STAT) || "R".equals(STAT) || "S".equals(STAT) || "Z".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        this.logger.info("###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

