/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class BjbUtils {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String getNullDefault(String str, String def) {
        return str == null ? def : str;
    }

    public static LocalDateTime parseDateTime(String str) {
        return LocalDateTime.parse(str, DATE_TIME_FORMATTER);
    }

    public static String formatDateTime(LocalDateTime localDateTime) {
        return localDateTime.format(DATE_TIME_FORMATTER);
    }

    public static LocalDate parseDate(String str) {
        return LocalDate.parse(str, DATE_FORMATTER);
    }

    public static String formatDate(LocalDate localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static BigDecimal str2BigDecimal(String decimal) {
        if (null == decimal || decimal.trim().length() == 0) {
            return null;
        }
        decimal = decimal.replaceAll(",", "");
        return new BigDecimal(decimal);
    }

    public static String bigDecimal2Str(BigDecimal decimal) {
        return decimal.multiply(ONE_HUNDRED).setScale(0).toString();
    }

    public static String subStringByte(String str, int temp) {
        char[] chars = str.toCharArray();
        boolean flag = false;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            temp = chars[i] > '\u00a1' ? (temp -= 2) : --temp;
            if (temp >= 0) continue;
            temp = i;
            flag = true;
            break;
        }
        return flag ? str.substring(0, temp) : str;
    }
}

