/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.detail;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.utils.DateUtils;
import kd.ebg.aqap.banks.zyb.dc.utils.GLBParser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest request, String pageTag) throws EBServiceException {
        return this.parseTodayDetail(request, pageTag);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest arg0, String arg1) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = arg0.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)arg1, (String)encoding);
        Element head = ebenk.getChild("Sys_Head");
        Element body = ebenk.getChild("Body");
        if (!"000000".equals(head.getChildTextTrim("ReturnCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), head.getChildText("ReturnMsg"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element TransList = body.getChild("List");
        List list = TransList.getChildren("Row");
        if (list.size() == 0) {
            return detailList;
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String currency = row.getChildText("Currency");
            detail.setCurrency(currency);
            String acctNo = row.getChildTextTrim("OtherAcNo");
            String accountName = row.getChildTextTrim("OtherName");
            String accountOpenNode = row.getChildTextTrim("OthBankName");
            detail.setOppAccNo(acctNo);
            detail.setOppAccName(accountName);
            detail.setOppBankName(accountOpenNode);
            String transferDate = row.getChildTextTrim("TransDate");
            String transferTime = row.getChildTextTrim("TransTime");
            String effectDate = row.getChildTextTrim("EffectDate");
            if (StringUtils.isNotEmpty((String)effectDate)) {
                transferDate = effectDate;
            }
            String transTime = GLBParser.convJsonDateToString(transferDate + " " + transferTime, "yyyy-MM-dd hh:mm:ss");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = simpleDateFormat.parse(transTime);
            }
            catch (ParseException e) {
                this.log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef" + e.toString());
            }
            detail.setTransTime(DateUtils.dateTolocalDateTime(date));
            detail.setTransDate(DateUtils.dateTolocalDate(date));
            String amount = row.getChildTextTrim("Amount");
            if (StringUtils.isEmpty((String)amount)) {
                this.log.error("\u8fc7\u6ee4\u5f53\u524d\u660e\u7ec6\uff0c\u8fd4\u56de\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002");
                continue;
            }
            BigDecimal payAmountD = new BigDecimal(amount);
            BigDecimal recAmountD = new BigDecimal(amount);
            String CDFlag = row.getChildTextTrim("DCFlag");
            if (CDFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(payAmountD);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(recAmountD);
            } else {
                this.log.error("\u8fc7\u6ee4\u5f53\u524d\u660e\u7ec6\uff0c\u501f\u8d37\u6807\u8bc6\u8fd4\u56de\u975e\u6b63\u5e38\u503c\uff1a{}", new Object[]{CDFlag});
                continue;
            }
            String AcctBal = row.getChildTextTrim("Balance");
            if (StringUtils.isNotEmpty((String)AcctBal)) {
                BigDecimal balance = new BigDecimal(AcctBal);
                detail.setBalance(balance);
            }
            String summary = "";
            if (row.getChildTextTrim("Remark") != null) {
                summary = row.getChildTextTrim("Remark");
            }
            detail.setExplanation(summary);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(arg0.getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(row.getChildTextTrim("Reference"));
            detailList.add(detail);
        }
        return detailList;
    }
}

