/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class GLBParser {
    static EBGLogger log = EBGLogger.getInstance().getLogger(GLBParser.class);

    public static BankResponse parseHeader(Element head) {
        BankResponse rsp = new BankResponse();
        String retCode = head.getChildTextTrim("ReturnCode");
        String retMsg = head.getChildTextTrim("ReturnMsg");
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StringUtils.catWithSpace((String[])new String[]{retCode, retMsg}));
        return rsp;
    }

    public static BankResponse parseBodyer(Element body) {
        BankResponse rsp = new BankResponse();
        String retCode = body.getChildTextTrim("ReturnCode");
        String retMsg = body.getChildTextTrim("ReturnMsg");
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StringUtils.catWithSpace((String[])new String[]{retCode, retMsg}));
        return rsp;
    }

    public static String convJsonDateToString(String jsonDate, String stringTemplate) {
        String resultString = null;
        try {
            Calendar cldCalendar = GLBParser.convToCalender(jsonDate, stringTemplate);
            resultString = GLBParser.convToString(cldCalendar, stringTemplate);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"GLBParser_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return resultString;
    }

    public static Calendar convToCalender(String str, String template) {
        Calendar cltResult = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(template, Locale.getDefault());
        try {
            Date date = sdf.parse(str);
            cltResult.setTime(date);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"GLBParser_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (Throwable)ex);
        }
        return cltResult;
    }

    public static String convToString(Calendar cld, String template) {
        String resultString = null;
        try {
            Date date = cld.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(template, Locale.getDefault());
            resultString = sdf.format(date);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"GLBParser_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return resultString;
    }
}

