/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.banks.zzb.dc.services.payment.allocation.QueryTransferImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TransferSameBankImpl
extends AbstractPayImpl
implements IPay {
    public static String TRANCODE = "B2EFundcollect";

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryTransferImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e", (String)"TransferSameBankImpl_0", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
        }
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(TRANCODE, Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        boolean transUp = UseConvertor.isTransUp((PaymentInfo)info);
        if (transUp) {
            JDomUtils.addChild((Element)body, (String)"BusType", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"BusType", (String)"1");
        }
        JDomUtils.addChild((Element)body, (String)"BusAcNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)body, (String)"TotalNum", (String)"1");
        JDomUtils.addChild((Element)body, (String)"TotalAmt", (String)info.getAmount().toString());
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"SeqNo", (String)"1");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"AcName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)info.getAmount().toString());
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)info.getExplanation());
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = bank_root.getChild("Head");
        String mcJnlno = head.getChildText("McJnlno");
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"McJnlno", (String)mcJnlno);
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = ZZB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        String returnCode = JDomUtils.getChildText((Element)body, (String)"ProcessState");
        String BatchNo = JDomUtils.getChildText((Element)body, (String)"BatchNo");
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"BatchNo", (String)BatchNo);
        if ("000000".equals(bankStatus)) {
            if ("OK".equalsIgnoreCase(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"TransferSameBankImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"TransferSameBankImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
            } else if ("FL".equalsIgnoreCase(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"TransferSameBankImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            } else if ("validation.errormsg".equals(bankStatus)) {
                if (ZZB_Parser.isTimeOut(headRsp).booleanValue()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"TransferSameBankImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"TransferSameBankImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"TransferSameBankImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"TransferSameBankImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return TRANCODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5212\u4e0b\u62e8", (String)"TransferSameBankImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equals(paymentInfo.getSubBizType());
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/B2EFundcollect.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

