/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tfyh.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tfyh.dc.services.Packer;
import kd.ebg.aqap.banks.tfyh.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element request = Packer.buildTranHead("QueryCurBal", Sequence.genSequence());
        Element body = request.getChild("body");
        Element list = JDomUtils.addChild((Element)body, (String)"list");
        JDomUtils.addChild((Element)list, (String)"accountCode", (String)bankBalanceRequest.getAcnt().getAccNo());
        return JDomUtils.root2String((Element)request, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!StringUtils.isEmpty((String)bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        List list = resBody.getChildren("list");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < list.size(); ++i) {
            Element record = (Element)list.get(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            String returnCode = record.getChildTextTrim("retCode");
            String returnMsg = record.getChildTextTrim("retMsg");
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            if ("1".equals(returnCode)) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)returnCode, (String)returnMsg));
            }
            String currency = record.getChildText("currencyCode");
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currency);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            String balance = record.getChildText("remainMoney");
            this.setCurrentBalance(balanceInfo, balance);
            String availBalance = record.getChildText("usableMoney");
            this.setAvailableBalance(balanceInfo, availBalance);
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QueryCurBal";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u53f7\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]);
    }
}

