/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tfyh.dc.services.payment;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tfyh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.tfyh.dc.services.Packer;
import kd.ebg.aqap.banks.tfyh.dc.services.Parser;
import kd.ebg.aqap.banks.tfyh.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]));
        }
        Element request = Packer.buildTranHead("Transfer", paymentInfo.getBankBatchSeqId());
        Element body = request.getChild("body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"voucherType", (String)"1");
        String dateStr = DateTimeUtils.format((Date)new Date(), (String)"yyMMdd");
        String count = "0";
        String billCode = "B" + dateStr + String.format("%04d", Integer.parseInt(count));
        JDomUtils.addChild((Element)entity, (String)"billCode", (String)billCode);
        JDomUtils.addChild((Element)entity, (String)"payerAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)entity, (String)"receiveAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)entity, (String)"receiveName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)entity, (String)"receiveBank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)entity, (String)"depositCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)entity, (String)"wishTime", (String)paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        PaymentUtil.setBookPayFlag((List)paymentInfos);
        JDomUtils.addChild((Element)entity, (String)"tradeMoney", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)entity, (String)"urgentFlag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)entity, (String)"privateFlag", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)entity, (String)"tradeUsage", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)entity, (String)"approvalFlag", (String)(BankBusinessConfig.isCheck() ? "1" : "0"));
        JDomUtils.addChild((Element)entity, (String)"userCode", (String)RequestContextUtils.getBankParameterValue((String)"userCode"));
        JDomUtils.addChild((Element)entity, (String)"subjectCode", (String)"");
        JDomUtils.addChild((Element)entity, (String)"absInfo", (String)"");
        JDomUtils.addChild((Element)entity, (String)"postScript", (String)"");
        JDomUtils.addChild((Element)entity, (String)"tradeMemo", (String)"");
        String unitCodeAccno = BankBusinessConfig.getPayUnitCode(paymentInfo.getAccNo());
        JDomUtils.addChild((Element)entity, (String)"unitCode", (String)(unitCodeAccno == null ? RequestContextUtils.getParameter().getBankParameter("unitCode") : unitCodeAccno));
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"billCode", (String)billCode);
        return JDomUtils.root2String((Element)request, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!StringUtils.isEmpty((String)bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f02\u5e38 :%s\u3002", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        Element body = root.getChild("body");
        Element entity = JDomUtils.getChildElement((Element)body, (String)"entity");
        String retCode = JDomUtils.getChildText((Element)entity, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)entity, (String)"retMsg");
        if ("0".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Transfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u4ed8\u6b3e", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-tfyh-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

