/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.hk.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.hk.service.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0001", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"ACCOUNT", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"CURRTYPE", (String)bankBalanceRequest.getBankCurrency());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"MESSAGE");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"COMMHEAD");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"RETCODE");
        Element body = JDomUtils.getChildElement((Element)message, (String)"BODY");
        if ("000".equals(retCode)) {
            if (null == body) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de BODY \u4e3a\u7a7a", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]));
            }
            String BALANCE = JDomUtils.getChildText((Element)body, (String)"BALANCE");
            String OKBALANCE = JDomUtils.getChildText((Element)body, (String)"OKBALANCE");
            String CURRTYPE = JDomUtils.getChildText((Element)body, (String)"CURRTYPE");
            BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(bankAcnt);
            balanceInfo.setCurrentBalance(new BigDecimal(BALANCE));
            if (!StringUtils.isEmpty((String)OKBALANCE)) {
                balanceInfo.setAvailableBalance(new BigDecimal(OKBALANCE));
            }
            balanceInfo.setBankCurrency(CURRTYPE);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801:%s", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]), retCode));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "0001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/CGBClient_mo/BankAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

