/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srb.cmp.services.utils;

import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class Common {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(Common.class);

    public static String createCommonMsg(String xml) {
        int digital = 10;
        String msgBody = "00" + xml;
        int msgBodyLen = Common.getLength(msgBody);
        String msgHead = Common.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) {
        String encoding = Common.getEncoding();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + encoding, (Throwable)e);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)Common.getEncoding());
        }
        catch (Exception e) {
            log.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)e);
            return "";
        }
    }

    public static String getEncoding() {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }

    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String responseMessage = ret_info;
        if (!StringUtils.isEmpty((String)ext_info)) {
            responseMessage = responseMessage + "_" + ext_info;
        }
        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);
        return response;
    }
}

