/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.payment.authorized;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.dc.services.payment.authorized.AuthorizedQueryPayImpl;
import kd.ebg.aqap.banks.cdb.dc.utils.CommonUtils;
import kd.ebg.aqap.banks.cdb.dc.utils.SignUtils;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthorizedPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorizedQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "STDC0301";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8", (String)"AuthorizedPaymentImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BankBusinessConfig.isPaymetByAuthorized();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String trCode = "STDC0301";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element REQ = JDomUtils.addChild((Element)Data, (String)"Req");
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        JDomUtils.addChild((Element)REQ, (String)"ItemCode");
        JDomUtils.addChild((Element)REQ, (String)"CorpNO", (String)RequestContextUtils.getBankParameterValue((String)"GID"));
        BigDecimal amount = paymentInfo.getAmount().setScale(2, 1);
        String payType = "0";
        payType = paymentInfo.is2SameCity() ? "1" : (amount.compareTo(new BigDecimal("50000.00")) < 0 ? "4" : "3");
        JDomUtils.addChild((Element)REQ, (String)"PayType", (String)payType);
        JDomUtils.addChild((Element)REQ, (String)"CurrencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)REQ, (String)"PyrName", (String)paymentInfo.getBankName());
        JDomUtils.addChild((Element)REQ, (String)"PyrAcct", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)REQ, (String)"PyrBankNO", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)REQ, (String)"PyrBank", (String)acnt.getBankName());
        JDomUtils.addChild((Element)REQ, (String)"PyrAddrStr", (String)acnt.getBankAddress());
        JDomUtils.addChild((Element)REQ, (String)"PyeName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)REQ, (String)"PyeAcct", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)REQ, (String)"PyeBankNO", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)REQ, (String)"PyeBank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)REQ, (String)"PyeAddrStr", (String)paymentInfo.getIncomeBankAddress());
        JDomUtils.addChild((Element)REQ, (String)"PayTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)REQ, (String)"PayAmt", (String)paymentInfo.getAmount().divide(new BigDecimal(10000)).setScale(6).toString());
        JDomUtils.addChild((Element)REQ, (String)"PayUse", (String)paymentInfo.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        String PacketMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        String signResMsg = SignUtils.sign(PacketMsg);
        Element Signature = JDomUtils.addChild((Element)Packet, (String)"Signature");
        JDomUtils.addChild((Element)Signature, (String)"DN", (String)signResMsg);
        String xmlMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        xmlMsg = CommonUtils.xmlToStrTrim(xmlMsg);
        return xmlMsg;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element packet = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element data = JDomUtils.getChildElement((Element)packet, (String)"Data");
        Element pub = JDomUtils.getChildElement((Element)data, (String)"Pub");
        String retCode = JDomUtils.getChildText((Element)pub, (String)"RetCode");
        String retMsg = JDomUtils.getChildText((Element)pub, (String)"RetMsg");
        Element res = JDomUtils.getChildElement((Element)data, (String)"Res");
        String status = JDomUtils.getChildText((Element)res, (String)"Status");
        String origMSGsID = JDomUtils.getChildText((Element)res, (String)"OrigMSGsID");
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"origMSGsID", (String)origMSGsID);
        if (!"0000".equals(retCode) && !"000000".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0d\u8bc6\u522b\u8be5\u6807\u5fd7\u3002", (String)"AuthorizedPaymentImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("A".equals(status) || "P".equals(status) || "S".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AuthorizedPaymentImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u7533\u8bf7\u5904\u7406\u4e2d", (String)"AuthorizedPaymentImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        } else if ("T".equals(status) || "F".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"AuthorizedPaymentImpl_4", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u7533\u8bf7\u5904\u7406\u5931\u8d25", (String)"AuthorizedPaymentImpl_5", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"AuthorizedPaymentImpl_6", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u72b6\u6001\u4e0d\u8bc6\u522b\u3002", (String)"AuthorizedPaymentImpl_7", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

