/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class TCommon {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TCommon.class);

    public static String createCommonMsg(String xml) {
        int digital = 10;
        String msgBody = "00" + xml;
        int msgBodyLen = TCommon.getLength(msgBody);
        String msgHead = TCommon.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) {
        String encoding = TCommon.getEncoding();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + encoding, (Throwable)e);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)false, (char)' ', (String)TCommon.getEncoding());
        }
        catch (Exception e) {
            log.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)e);
            return "";
        }
    }

    public static String getEncoding() {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }

    private static byte[] read(DataInputStream dis, int length) {
        byte[] bytes = new byte[length];
        try {
            int result = dis.read(bytes);
            if (result - length != 0) {
                log.info("\u76ee\u6807\u8bfb\u53d6\u957f\u5ea6:" + length + ", \u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + result);
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6d41\u5931\u8d25,IOException%s", (String)"TCommon_4", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return bytes;
    }

    private static String read2String(DataInputStream dis, int length, String encoding) {
        try {
            String str = new String(TCommon.read(dis, length), encoding);
            str = StringUtils.isEmpty((String)str) ? "" : str.trim();
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301%s\u5b57\u7b26\u7f16\u7801\u3002", (String)"TCommon_5", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), encoding), (Throwable)e);
        }
    }

    public static String recvMessage(InputStream inputStream) {
        String encoding = RequestContextUtils.getCharset();
        try {
            DataInputStream dis = new DataInputStream(inputStream);
            String length = TCommon.read2String(dis, 10, encoding);
            int len = Integer.parseInt(length);
            String str = TCommon.read2String(dis, 2, encoding);
            String xmlString = TCommon.read2String(dis, len - 2, encoding);
            log.info("##\u63a5\u6536\u62a5\u6587\u957f\u5ea6\uff1a" + length + ", \u62a5\u4f53\u524d\u4e24\u5b57\u8282\uff1a" + str + ", \u62a5\u4f53\u5185\u5bb9\uff1a" + xmlString);
            return xmlString;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u6536\u6570\u636e\u5f02\u5e38%s\u3002", (String)"TCommon_6", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String parseRecvMsg(String input) {
        log.info("###recv data\uff1a" + input);
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }

    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String responseMessage = ret_info;
        if (!StringUtils.isEmpty((String)ext_info)) {
            responseMessage = responseMessage + "_" + ext_info;
        }
        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);
        return response;
    }
}

