/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element body = AntUtils.createBody();
        BankAcnt bankAcnt = (BankAcnt)bankBalanceRequest.getBankAcntList().get(0);
        JDomUtils.addChild((Element)body, (String)"partner", (String)RequestContextUtils.getBankParameterValue((String)"partner_id"));
        JDomUtils.addChild((Element)body, (String)"cardNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"currencyCode", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"cashExCode", (String)"CSH");
        JDomUtils.addChild((Element)body, (String)"cardType", (String)"");
        return AntUtils.execute(body, this.getBizCode(), Lists.newArrayList((Object[])new String[]{"cardNo", "currencyCode", "cashExCode"}));
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element response = AntUtils.getResponse(s);
        Element body = response.getChild("body");
        AntUtils.getResultInfo(body, true);
        String currencyCode = JDomUtils.getChildText((Element)body, (String)"currencyCode");
        String actualBalance = JDomUtils.getChildText((Element)body, (String)"actualBalance");
        String availableBalance = JDomUtils.getChildText((Element)body, (String)"availableBalance");
        String freezeAmount = JDomUtils.getChildText((Element)body, (String)"freezeAmount");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, (BankAcnt)bankBalanceRequest.getBankAcntList().get(0));
        this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currencyCode);
        this.setCurrentBalance(balanceInfo, actualBalance);
        this.setAvailableBalance(balanceInfo, availableBalance);
        this.setFreezeBalance(balanceInfo, freezeAmount);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ant.ebank.acount.balance.query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        AntUtils.setURI(factory);
    }
}

