/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.services.payment;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.banks.zjws.opa.utils.ResultInfo;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = AntUtils.createBody();
        JDomUtils.addChild((Element)body, (String)"partner", (String)RequestContextUtils.getBankParameterValue((String)"partner_id"));
        JDomUtils.addChild((Element)body, (String)"channelSeqNo", (String)paymentInfo.getBankDetailSeqID());
        PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        JDomUtils.addChild((Element)body, (String)"smsCode", (String)"");
        JDomUtils.addChild((Element)body, (String)"amt", (String)this.getAmt(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)body, (String)"currencyCode", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)body, (String)"payerAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payerName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"payeeAcctType", (String)"bankcard");
        JDomUtils.addChild((Element)body, (String)"payeeAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"payeeBankBranchCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"payeeBankCode", (String)"");
        JDomUtils.addChild((Element)body, (String)"remark", (String)paymentInfo.getExplanation().substring(0, Math.min(32, paymentInfo.getExplanation().length())));
        JDomUtils.addChild((Element)body, (String)"partnerBillBizNo", (String)"");
        return AntUtils.execute(body, this.getBizCode(), Lists.newArrayList((Object[])new String[]{"channelSeqNo", "smsCode", "amt", "currencyCode", "payerAcctNo", "payerName", "payeeAcctType", "payeeAcctNo", "payeeName", "payeeBankBranchCode", "payeeBankCode", "remark"}));
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        Element response = AntUtils.getResponse(s);
        Element body = response.getChild("body");
        ResultInfo resultInfo = AntUtils.getResultInfo(body, false);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (resultInfo.isSuccess()) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)resultInfo.getResultMsg());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)resultInfo.getStatusAndCode(), (String)resultInfo.getResultMsg());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ant.ebank.transfer.single.stdtrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u5355\u7b14\u8f6c\u8d26", (String)"", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String getAmt(BigDecimal amt) {
        String amtS = PackerUtils.convertYuan2CentStr((BigDecimal)amt);
        return StringLength.fixed((String)amtS, (String)"0", (int)15, (boolean)false);
    }

    public void configFactory(ConnectionFactory factory) {
        AntUtils.setURI(factory);
    }
}

