/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.intelligentpay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.intelligentpay.IntelligentQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IntelligentPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IntelligentQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLINTTRN";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u667a\u80fd\u652f\u4ed8\u63a5\u53e3", (String)"IntelligentPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BankBusinessConfig.isAllTransfer() && (paymentInfo.is2SameBank() || this.isCompany(paymentInfo) || paymentInfo.getIndividual() != false);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        int payType = 1;
        int payFlg = 1;
        String recOpenBankName = "";
        String recOpenBankCode = "";
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLINTTRN");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"clientID", (String)paymentInfo.getBankDetailSeqID());
            JDomUtils.addChild((Element)row, (String)"preFlg", (String)"0");
            JDomUtils.addChild((Element)row, (String)"preDate", (String)"");
            JDomUtils.addChild((Element)row, (String)"preTime", (String)"");
            if (paymentInfo.is2SameBank()) {
                payType = BankBusinessConfig.isMatchCompanyAcc(paymentInfo.getAccNo()) && BankBusinessConfig.isMatchCompanyAcc(paymentInfo.getIncomeAccNo()) ? 3 : 2;
            } else {
                payType = 1;
                recOpenBankName = paymentInfo.getIncomeBankName();
                recOpenBankCode = paymentInfo.getIncomeCnaps();
            }
            JDomUtils.addChild((Element)row, (String)"payType", (String)String.valueOf(payType));
            payFlg = payType == 1 && paymentInfo.is2Urgent() ? 0 : 1;
            JDomUtils.addChild((Element)row, (String)"payFlg", (String)String.valueOf(payFlg));
            JDomUtils.addChild((Element)row, (String)"payAccountNo", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"recOpenBankName", (String)recOpenBankName);
            JDomUtils.addChild((Element)row, (String)"recOpenBankCode", (String)recOpenBankCode);
            JDomUtils.addChild((Element)row, (String)"tranAmount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"abstract", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)row, (String)"memo", (String)paymentInfo.getUseCn());
            JDomUtils.addChild((Element)row, (String)"chkNum", (String)("KD" + paymentInfo.getBankDetailSeqId()));
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2String((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

