/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.PaymentInfosUtil;
import kd.ebg.aqap.banks.citic.dc.services.StatusCodeHelper;
import kd.ebg.aqap.banks.citic.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;

public class SalaryQueryImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 20;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLSALDET";
    }

    public Boolean SupportPage() {
        return true;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"3.3.3 \u4ee3\u53d1\u5de5\u8d44\u660e\u7ec6\u67e5\u8be2", (String)"SalaryQueryImpl_33", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLSALDET");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"20");
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)this.getCurrentPage());
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List<PaymentInfo> paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        String totalRecords = root.getChildText("totalRecords");
        if (StringUtils.isNotEmpty((String)totalRecords)) {
            int currentRecords;
            int total = Integer.parseInt(totalRecords);
            if (total > (currentRecords = Integer.parseInt(this.getCurrentPage()) + 20 - 1)) {
                this.setLastPage(false);
                this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
            } else {
                this.setLastPage(true);
            }
        }
        if (!"AAAAAAA".equalsIgnoreCase(status)) {
            if (StatusCodeHelper.isDoingCode(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)statusText);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)statusText);
            }
            return new EBBankPayResponse((List)paymentInfos);
        }
        Element list = root.getChild("list");
        List rowList = list.getChildren("row");
        if (rowList == null || rowList.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)" \u8fd4\u56de<row>\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"SalaryQueryImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        paymentInfos = this.preBatchSameItemCheck(request, Integer.parseInt(this.getCurrentPage()) == 1);
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            String employeeName = row.getChildTextTrim("employeeName");
            String recAccountNo = row.getChildTextTrim("recAccountNo");
            String tranAmount = row.getChildTextTrim("tranAmount");
            String statusRow = row.getChildTextTrim("status");
            String statusTextRow = row.getChildTextTrim("statusText");
            PaymentInfo info = PaymentInfosUtil.selectPaymentInfo(paymentInfos, recAccountNo, employeeName, tranAmount);
            if (null == info) continue;
            this.handlePayStatus(info, statusRow, statusTextRow);
        }
        this.processingBankItemDataHandler(rowList);
        if (this.isLastPage()) {
            PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)false);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request, boolean isFirstPage) {
        List paymentInfos = request.getPaymentInfos();
        if (isFirstPage) {
            paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
            request.setPaymentInfos(paymentInfos);
            PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        }
        return paymentInfos;
    }

    @Override
    public String getBankDataKey(Element row) {
        String employeeName = row.getChildTextTrim("employeeName");
        String recAccountNo = row.getChildTextTrim("recAccountNo");
        String tranAmount = row.getChildTextTrim("tranAmount");
        return recAccountNo + employeeName + new BigDecimal(tranAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, Element row) {
        String statusRow = row.getChildTextTrim("status");
        String statusTextRow = row.getChildTextTrim("statusText");
        this.handlePayStatus(tempInfo, statusRow, statusTextRow);
    }

    public void handlePayStatus(PaymentInfo info, String status, String statusMsg) {
        if ("AAAAAAA".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)statusMsg);
        } else if ("CCCCCCC".equals(status) || "AAAAAAB".equals(status) || "AAAAAAC".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)statusMsg);
        } else if ("AAAAAAC".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)statusMsg);
        } else if (StatusCodeHelper.isUnkownCode(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)statusMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)statusMsg);
        }
    }
}

