/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.payment.allocation;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5212\u62e8\u3001\u5bf9\u5916\u652f\u4ed8\u540c\u6b65\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = Packer.buildHead("200205", Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfo.getBankBatchSeqId());
        if (!StringUtils.isEmpty((String)RequestContextUtils.getBankParameterValue((String)"signDate4Test"))) {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)RequestContextUtils.getBankParameterValue((String)"signDate4Test"));
        } else {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)Packer.formatDate(paymentInfo.getSubmitSuccessTime()));
        }
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            if ("1_2100".equals(rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,2100\u8be5\u6d41\u6c34\u4e0d\u5b58\u5728 \u89c6\u4e3a \u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String ret_code = body.getChildTextTrim("stat");
        String error_info = body.getChildTextTrim("error_info");
        if ("6".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
        } else if ("9".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
        } else if ("3".equals(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)ret_code, (String)error_info);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        String recv = super.recv(inputStream);
        return recv.substring(12);
    }
}

