/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.payment.salary;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.banks.lzb.dc.services.proxy.ProxyQryResultDownload;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I200201
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 5000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead(this.getBizCode(), Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        String serialNo = paymentInfo.getBankRefID();
        if (StringUtils.isEmpty((String)serialNo)) {
            String errorMsg = ResManager.loadKDString((String)"serial_no\u8fd4\u56de\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u63d0\u4ea4\u4ed8\u6b3e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u540e\u518d\u624b\u5de5\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"I200201_0", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)errorMsg, (String)"", (String)"");
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        if (submitSuccessTime == null) {
            submitSuccessTime = paymentInfo.getInsertTime();
        }
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)submitSuccessTime.format(DateTimeFormatter.BASIC_ISO_DATE));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String data;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        Element body = root.getChild("body");
        int recordNum = this.toDigit(body.getChildTextTrim("record_num"));
        int fieldNum = this.toDigit(body.getChildTextTrim("field_num"));
        if (recordNum == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u672a\u8fd4\u56de\u7ed3\u679c\uff0c\u4ed8\u6b3e\u72b6\u6001\u672a\u77e5\u3002", (String)"I200201_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if ("1".equalsIgnoreCase(file_flag)) {
            ProxyQryResultDownload proxyDownload = new ProxyQryResultDownload();
            String file_name = body.getChildTextTrim("file_name");
            data = proxyDownload.doBiz(file_name);
        } else {
            data = body.getChildTextTrim("serial_record");
        }
        String[] content = StringUtils.split((String)data, (String)"|");
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        int i = 1;
        while (true) {
            if (i > recordNum) {
                MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
                matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
                matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
                List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
                return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
            }
            String STAT = content[fieldNum * i + 9];
            String CARD_NO = content[fieldNum * i + 1];
            String ACNAME = content[fieldNum * i + 3];
            String AMT = content[fieldNum * i + 5];
            String ERR_MSG = content[fieldNum * i + 10];
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(CARD_NO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("6".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("9".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("3".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
            ++i;
        }
    }

    public Integer toDigit(String num) {
        try {
            return Integer.parseInt(num);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return "";
    }
}

