/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.area;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.banks.boc.net.area.Area;
import kd.ebg.aqap.business.account.atomic.ISyncAccount;
import kd.ebg.aqap.common.framework.utils.XlsUtlis;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.bank.info.EBBankResponse;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AreaStore
implements ISyncAccount {
    public static final String fileName = "areaCode.xls";
    public static final String[] rowNameArray = new String[]{"an", "bn", "cn"};
    private static Area[] areas;
    public static AreaStore instance;

    public static synchronized AreaStore getInstance() {
        if (null == instance) {
            instance = new AreaStore();
        }
        return instance;
    }

    public AreaStore() {
        try {
            String sheetName = PropertiesConstants.getValue((String)"BOC_AREA_TABLE");
            List resultList = XlsUtlis.analysisXlsFile((String)fileName, (String[])rowNameArray, (String)sheetName, (boolean)true);
            int n = resultList.size();
            areas = new Area[n];
            for (int i = 0; i < areas.length; ++i) {
                Map map = (Map)resultList.get(i);
                String an = (String)map.get("an");
                String bn = (String)map.get("bn");
                String cn = (String)map.get("cn");
                String code = StrUtil.trim((CharSequence)an);
                String abcArea = StrUtil.trim((CharSequence)bn);
                String keywords = StrUtil.trim((CharSequence)cn);
                AreaStore.areas[i] = new Area(code, abcArea, keywords);
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public Area matchArea(String address) {
        if (StringUtils.isNotEmpty((String)address)) {
            for (int i = 0; i < areas.length; ++i) {
                if (-1 == areas[i].getKeywords().indexOf(address)) continue;
                return areas[i];
            }
        }
        return null;
    }

    public Map<String, String> getAreaCodeAndCnap(String bankCity) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("CNAP", "");
        result.put("AREACODE", "");
        return result;
    }

    public EBBankResponse doBiz(BankRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankRequest bankRequest) {
        return true;
    }
}

