/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.kit;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.bankstatus.IBankStatus;
import kd.ebg.aqap.business.bankstatus.Status;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.ClassPathResource;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FailCode {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FailCode.class);
    public static final String fileName = "failCode.xls";
    public static FailCode instance;
    private Map<String, String> failCodeMap;
    public static B2E0009 b2e0009FailCode;
    public static B2E0061 b2e0061FailCode;

    public static FailCode getInstance() {
        if (null == instance) {
            instance = new FailCode();
        }
        return instance;
    }

    private FailCode() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.failCodeMap = new HashMap<String, String>(16);
        InputStream is = null;
        HSSFWorkbook workbook = null;
        try {
            is = new ClassPathResource(fileName).getInputStream();
            workbook = new HSSFWorkbook(is);
            this.read2Map(workbook, this.failCodeMap);
        }
        catch (Exception e1) {
            logger.error("\u8bfb\u53d6\u4ea4\u6613\u5931\u8d25\u72b6\u6001\u7801\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        finally {
            if (null != is) {
                try {
                    if (null != workbook) {
                        workbook.close();
                    }
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void read2Map(HSSFWorkbook workbook, Map<String, String> failCodeMap) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        for (int startRow = 1; startRow < lastRowNum; ++startRow) {
            HSSFRow row = sheet.getRow(startRow);
            HSSFCell cell0 = row.getCell(0);
            HSSFCell cell1 = row.getCell(1);
            failCodeMap.put(cell0.getStringCellValue().trim(), cell1.getStringCellValue().trim());
        }
    }

    public boolean isFail(String errorCode) {
        return this.failCodeMap.containsKey(errorCode);
    }

    static {
        b2e0009FailCode = new B2E0009();
        b2e0061FailCode = new B2E0061();
    }

    public static class B2E0061
    implements IBankStatus {
        public List<Status> getStatusList() {
            return Lists.newArrayList((Object[])new Status[]{Status.newStatus((String)"B074", (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u5458\u5bf9\u4ed8\u6b3e\u8d26\u53f7\u65e0\u6b64\u529f\u80fd\u6743\u9650,\u8bf7\u4fee\u6539\u3002", (String)"FailCode_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (PaymentState)PaymentState.FAIL)});
        }
    }

    public static class B2E0009
    implements IBankStatus {
        public List<Status> getStatusList() {
            return Lists.newArrayList((Object[])new Status[]{Status.newStatus((String)"B4987", (String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\u3001\u6237\u540d\u4fe1\u606f\u4e0d\u7b26\u3002", (String)"FailCode_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (PaymentState)PaymentState.FAIL), Status.newStatus((String)"B4986", (String)ResManager.loadKDString((String)"\u67e5\u8be2\u6536\u6b3e\u8d26\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"FailCode_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (PaymentState)PaymentState.FAIL), Status.newStatus((String)"B4988", (String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\u6216\u6237\u540d\u6709\u8bef\u3002", (String)"FailCode_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (PaymentState)PaymentState.FAIL), Status.newStatus((String)"B4887", (String)ResManager.loadKDString((String)"\u6237\u540d\u9519\u8bef\u3002", (String)"FailCode_4", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (PaymentState)PaymentState.FAIL)});
        }
    }
}

