/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AggregateHisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(AggregateHisBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        Objects.requireNonNull(request.getStartDate(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AggregateHisBalanceImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        Objects.requireNonNull(request.getEndDate(), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AggregateHisBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            BankAcnt acnt = request.getAcnt();
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0051");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0051-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0051-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
            JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)account, (String)"actcur", (String)acnt.getCurrency());
            JDomUtils.addChild((Element)account, (String)"curflag");
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)datescope, (String)"to", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0051-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(16);
        List childen = trn.getChildren("b2e0051-rs");
        for (Element child : childen) {
            Element acc = child.getChild("account");
            String account = acc.getChildTextTrim("actacn");
            Element balance = child.getChild("balance");
            String bokendbal = balance.getChildTextTrim("bokendbal");
            String tdybal = balance.getChildTextTrim("tdybal");
            String baldat = balance.getChildTextTrim("baldat");
            BalanceInfo info = new BalanceInfo();
            this.setBankAcnt(info, request.getBankAcntList(), account);
            this.setAvailableBalance(info, tdybal);
            this.setCurrentBalance(info, bokendbal);
            this.setBankCurrency(info, request.getBankCurrency());
            this.setBalanceDateTime(info, baldat + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            hisBalanceList.add(info);
        }
        return new EBBankBalanceResponse(hisBalanceList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e0051";
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u6237\u5386\u53f2\u53ef\u7528\u4f59\u989d\u67e5\u8be2", (String)"AggregateHisBalanceImpl_4", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

