/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.detail;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.DateUtils;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(HisDetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        String tradeName = "BY0006";
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot(tradeName);
        Element map = new Element("map");
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        ZonedDateTime beginDate = bankDetailRequest.getStartDate().atStartOfDay(ZoneId.systemDefault());
        String startDate = DateUtil.formatDate((Date)Date.from(beginDate.toInstant()));
        ZonedDateTime overDate = bankDetailRequest.getEndDate().atStartOfDay(ZoneId.systemDefault());
        String endDate = DateUtil.formatDate((Date)Date.from(overDate.toInstant()));
        JDomUtils.addChild((Element)map, (String)"bankAcc", (String)accNo);
        try {
            JDomUtils.addChild((Element)map, (String)"queryDateBegin", (String)HZYQ_Packer.strToDateFormat(startDate));
            JDomUtils.addChild((Element)map, (String)"queryDateEnd", (String)HZYQ_Packer.strToDateFormat(endDate));
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        JDomUtils.addChild((Element)root, (Element)head);
        JDomUtils.addChild((Element)root, (Element)map);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber(tradeName) + RspMsg;
        return TCommon.createCommonMsg(rspmsg);
    }

    public String recv(InputStream inputStream) {
        return HisDetailImpl.parseRecvMsg(super.recv(inputStream));
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(16);
        }
        return "";
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return new EBBankDetailResponse(this.parseDetail(request, responseStr));
    }

    private List<DetailInfo> parseDetail(BankDetailRequest bankdetailrequest, String rspStr) throws EBServiceException {
        if (StringUtils.isEmpty((String)rspStr)) {
            log.info("\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"HisDetailImpl_0", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        if (!"0".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"HisDetailImpl_3", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), retMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element ld = JDomUtils.getChildElement((Element)root, (String)"loopData");
        if (ld == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"HisDetailImpl_3", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), retMsg);
            log.info(errorMsg);
            return detailList;
        }
        List list = ld.getChildren("row");
        if (list == null || list.size() == 0) {
            log.info("\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u4e3a\u7a7a");
            return detailList;
        }
        log.info("\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u603b\u6761\u6570\uff1a{}", (Object)list.size());
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < list.size(); ++i) {
            String bal;
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String serialId = row.getChildTextTrim("serialId");
            String bankAcc = row.getChildTextTrim("bankAcc");
            String bankName = row.getChildTextTrim("bankName");
            String accName = row.getChildTextTrim("accName");
            detail.setAccNo(bankAcc);
            detail.setAccName(bankName);
            detail.setBankName(accName);
            String oppAccNo = row.getChildTextTrim("oppAccNo");
            String oppAccName = row.getChildTextTrim("oppAccName");
            String oppAccBank = row.getChildTextTrim("oppAccBank");
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setOppBankName(oppAccBank);
            String cdSign = row.getChildTextTrim("cdSign");
            String amt = row.getChildTextTrim("amt");
            if ("1".equals(cdSign)) {
                detail.setDebitAmount(new BigDecimal("".equals(amt) || amt == null ? "0.00" : amt));
                detail.setCreditAmount(new BigDecimal("0.0"));
            }
            if ("0".equals(cdSign)) {
                detail.setCreditAmount(new BigDecimal("".equals(amt) || amt == null ? "0.00" : amt));
                detail.setDebitAmount(new BigDecimal("0.0"));
            }
            if (StringUtils.isNotEmpty((String)(bal = row.getChildTextTrim("bal")))) {
                BigDecimal balance = new BigDecimal(bal);
                detail.setBalance(balance);
            }
            String voucherNo = row.getChildTextTrim("voucherNo");
            String transDate = row.getChildTextTrim("transDate");
            String transTime = row.getChildTextTrim("transTime");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date dates = simpleDateFormat.parse(transTime);
                detail.setTransDate(DateUtils.dateTolocalDate(dates));
                detail.setTransTime(DateUtils.dateTolocalDateTime(dates));
            }
            catch (ParseException e1) {
                log.info("\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684\u65e5\u671f\u9519\u8bef " + e1.getMessage());
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684\u65e5\u671f\u9519\u8bef\u3002", (String)"HisDetailImpl_2", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (Throwable)e1);
            }
            detail.setCurrency(bankdetailrequest.getAcnt().getCurrency());
            String abs = row.getChildTextTrim("abs");
            if (!StringUtils.isEmpty((String)abs)) {
                int index = abs.indexOf("_KD_");
                if (index != -1) {
                    String bankDetailSeqId = BizNoUtil.getId((String)abs);
                    String remark = BizNoUtil.getMsg((String)abs);
                    detail.setKdFlag(bankDetailSeqId);
                    detail.setPayBankDetailSeqID(bankDetailSeqId);
                    if (StringUtils.isEmpty((String)detail.getExplanation())) {
                        detail.setExplanation(remark);
                    }
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                } else if (StringUtils.isEmpty((String)detail.getExplanation())) {
                    detail.setExplanation(abs);
                }
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(serialId);
            String accNo = bankdetailrequest.getHeader().getAcnt().getAccNo();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            log.info("\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u89e3\u6790\u51fa\u7684\u5339\u914d\u7801\uff1a{}-{}", new Object[]{detail.getReceiptNo(), detail.getTransDate()});
            detailList.add(detail);
        }
        log.info("\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u89e3\u6790\u51fa\u7684\u7ed3\u679c\u6761\u6570\uff1a{}", (Object)detailList.size());
        return detailList;
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BY0006";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

