/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.services;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.opa.services.SzdbNewMessageUtil;
import kd.ebg.aqap.banks.pab.opa.services.utils.EncodingUtil;
import kd.ebg.aqap.banks.pab.opa.sign.util.B2BICUtils;
import kd.ebg.aqap.banks.pab.opa.sign.util.StringTool;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringFormater;

public class PackerHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PackerHelper.class);

    public static String createReqMsgWithHead(String reqNo, String tradeCode, String xmlStr, String zuID) {
        String request = PackerHelper.createReqMsgWithHead(reqNo, tradeCode, xmlStr, zuID, 0);
        return request;
    }

    public static String createReqMsgWithHead(String reqNo, String tradeCode, String xmlStr, String zuID, int pageNum) {
        StringBuilder sb = new StringBuilder();
        String charSet = RequestContextUtils.getCharset();
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u62a5\u6587\u7c7b\u522b\u7f16\u53f7", (String)"PackerHelper_0", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "A00101", 6);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u62a5\u6587\u7f16\u53f7", (String)"PackerHelper_1", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), SzdbNewMessageUtil.getCharsetParameterValue(RequestContextUtils.getCharset()), 2);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"PackerHelper_2", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "01", 2);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u4f01\u4e1a\u94f6\u4f01\u76f4\u8054\u6807\u51c6\u4ee3\u7801\u3002", (String)"PackerHelper_3", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), RequestContextUtils.getBankParameterValue((String)"EnterpriseCode"), 20);
        int xmlLeng = EncodingUtil.encode(xmlStr, charSet).length;
        PackerHelper.addFomatedFieldNumber(sb, ResManager.loadKDString((String)"\u63a5\u6536\u62a5\u6587\u957f\u5ea6", (String)"PackerHelper_4", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), String.valueOf(xmlLeng), 10);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u4ea4\u6613\u7801", (String)"PackerHelper_5", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), tradeCode, 6);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u64cd\u505a\u5458\u4ee3\u7801", (String)"PackerHelper_6", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "", 5);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u670d\u52a1\u7c7b\u578b", (String)"PackerHelper_7", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "01", 2);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"PackerHelper_8", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"), 8);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"PackerHelper_9", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), DateTimeUtils.format((Date)new Date(), (String)"HHmmss"), 6);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u8bf7\u6c42\u65b9\u7cfb\u7edf\u6d41\u6c34\u53f7\u3002", (String)"PackerHelper_10", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), reqNo, 20);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u8fd4\u56de\u7801", (String)"PackerHelper_11", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "", 6);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u8fd4\u56de\u63cf\u8ff0", (String)"PackerHelper_12", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "ZuID=" + zuID, 100);
        if (0 == pageNum) {
            PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u540e\u7eed\u5305\u6807\u5fd7", (String)"PackerHelper_13", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "0", 1);
        } else {
            PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u540e\u7eed\u5305\u6807\u5fd7", (String)"PackerHelper_13", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "1", 1);
        }
        PackerHelper.addFomatedFieldNumber(sb, ResManager.loadKDString((String)"\u8bf7\u6c42\u6b21\u6570", (String)"PackerHelper_14", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), String.valueOf(pageNum), 3);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u7b7e\u540d\u6807\u8bc6", (String)"PackerHelper_15", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "0", 1);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u7b7e\u540d\u6570\u636e\u5305\u683c\u5f0f\u3002", (String)"PackerHelper_16", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "1", 1);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u7b7e\u540d\u7b97\u6cd5", (String)"PackerHelper_17", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "RSA-SHA1", 12);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u7b7e\u540d\u6570\u636e\u957f\u5ea6", (String)"PackerHelper_18", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "0000000000", 10);
        PackerHelper.addFomatedField(sb, ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u76ee", (String)"PackerHelper_19", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), "0", 1);
        sb.append(xmlStr);
        return PackerHelper.signData(sb.toString(), charSet);
    }

    public static String signData(String beforeSignData, String charSet) {
        try {
            CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
            CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
            if (certInfo == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u7b7e\u540d\u8bc1\u4e66\u3002", (String)"PackerHelper_20", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]));
            }
            CipherInfo cipherInfo = PackerHelper.getCipherInfo(certInfo.getFileContent());
            byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
            String signData = B2BICUtils.sign(beforeSignData.getBytes(charSet), charSet, fileContent, certInfo.getCertPassword());
            String signDataLength = String.valueOf(signData.getBytes(charSet).length);
            return beforeSignData + StringTool.fillChar(signDataLength, '0', 6, true) + signData;
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff1a%s\u3002", (String)"PackerHelper_24", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
    }

    public static void addFomatedField(StringBuilder sb, String fieldName, String fieldValue, int fixLen) {
        String formatedValue = PackerHelper.formatLen4Normal(fieldName, fieldValue, fixLen);
        sb.append(formatedValue);
    }

    public static void addFomatedFieldNumber(StringBuilder sb, String fieldName, String fieldValue, int fixLen) {
        String formatedValue = PackerHelper.formatLen4Number(fieldName, fieldValue, fixLen);
        sb.append(formatedValue);
    }

    public static String formatLen4Number(String fieldName, String fieldValue, int fixLen) {
        try {
            return StringFormater.formatLen((String)fieldValue, (int)fixLen, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316%1$s\u5b57\u6bb5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002%3$s", (String)"PackerHelper_25", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), fieldName, e.getMessage()), (Throwable)e);
        }
    }

    public static String formatLen4Normal(String fieldName, String fieldValue, int fixLen) {
        try {
            return StringFormater.formatLen((String)fieldValue, (int)fixLen, (boolean)false, (char)' ', (String)RequestContextUtils.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316%1$s\u5b57\u6bb5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002%3$s", (String)"PackerHelper_25", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), fieldName, e.getMessage()), (Throwable)e);
        }
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

