/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.payment.singlePay;

import kd.ebg.aqap.banks.adbc.dc.services.Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;

final class PayPacker {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    PayPacker() {
    }

    public String packPay(PaymentInfo[] paymentInfos) {
        this.logger.info("\u8f6c\u8d26\u652f\u4ed8\u5f00\u59cb----");
        String body = this.createBody(paymentInfos[0]);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.biz.001.1", bodyLen, paymentInfos);
        String reqMsg = header + body;
        return reqMsg;
    }

    private String createBody(PaymentInfo paymentInfo) {
        this.logger.info("\u5c01\u88c5\u8f6c\u8d26\u652f\u4ed8\u62a5\u6587\u5f00\u59cb------");
        StringBuilder sbBody = new StringBuilder();
        try {
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(RequestContextUtils.getCharset()).append("\"?>\r\n");
            sbBody.append("<Document xmlns=\"").append("eb.biz.001.1").append("\">\r\n");
            sbBody.append("<PayInfo>");
            sbBody.append("<PayerAccount>").append(paymentInfo.getAccNo()).append("</PayerAccount>");
            sbBody.append("<PayerName>").append(paymentInfo.getAccName()).append("</PayerName>");
            sbBody.append("<PayeeAccount>").append(paymentInfo.getIncomeAccNo()).append("</PayeeAccount>");
            sbBody.append("<PayeeName>").append(paymentInfo.getIncomeAccName()).append("</PayeeName>");
            sbBody.append("<PayeeOpenBankCode>").append(paymentInfo.getIncomeCnaps() != null ? paymentInfo.getIncomeCnaps() : "").append("</PayeeOpenBankCode>");
            sbBody.append("<Amount>").append(paymentInfo.getAmount().toString()).append("</Amount>");
            sbBody.append("<Usage>").append(paymentInfo.getExplanation()).append("</Usage>");
            String isUrgent = "0";
            if (paymentInfo.is2Urgent()) {
                isUrgent = "1";
            }
            this.logger.info("paymentInfo.is2Urgent()\u52a0\u6025\u72b6\u6001----" + paymentInfo.is2Urgent());
            sbBody.append("<InstancyStatus>").append(isUrgent).append("</InstancyStatus>");
            sbBody.append("<ExtContent>").append(paymentInfo.getExplanation()).append("</ExtContent>");
            sbBody.append("</PayInfo>");
            sbBody.append("</Document>");
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return sbBody.toString();
    }
}

