/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"ACCT_NO", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"ACC_TYPE", (String)"");
        String requestStr = CommonUtil.getPackerData(Constants.TODAY_BALANCE, body);
        return requestStr;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        Element array = body.getChild("ARRAY");
        List list = array.getChildren("STRUCT");
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        for (Element element1 : list) {
            BalanceInfo balanceInfo = new BalanceInfo();
            try {
                String accNo = element1.getChildText("ACC_NO");
                if (!bankBalanceRequest.getAcnt().getAccNo().equals(accNo)) {
                    logger.info("\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u6237\u4e0d\u662f\u67e5\u8be2\u7684\u8d26\u6237\uff0c\u4e0d\u53d6\u4f59\u989d");
                    continue;
                }
                String balance = element1.getChildText("LEDGER_BAL");
                String availBal = element1.getChildText("AVAIL_BAL");
                String freezeAmt = element1.getChildText("PLEDGED_AMT");
                String lastDayBal = element1.getChildText("LASTDAY_BAL");
                balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
                balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)availBal, (Boolean)true));
                balanceInfo.setLastDayAvlBalance(BigDecimalHelper.str2BigDecimalForBalance((String)lastDayBal, (Boolean)true));
                balanceInfo.setFreezeBalance(BigDecimalHelper.str2BigDecimalForBalance((String)freezeAmt, (Boolean)true));
                balanceInfo.setBankCurrency(bankBalanceRequest.getCurrency());
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
            }
            catch (Exception e) {
                balanceInfo.setError(e.getMessage());
            }
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            balanceInfoList.add(balanceInfo);
        }
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ebBankBalanceResponse.setBalances(balanceInfoList);
        return ebBankBalanceResponse;
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.TODAY_BALANCE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

