/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankCompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"PAYERACC", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAYERNAME", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"CURRENCY", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"PAYERACCBANK", (String)"");
        JDomUtils.addChild((Element)body, (String)"CUSTMERTYPE", (String)"2");
        JDomUtils.addChild((Element)body, (String)"PAYEEACC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"PAYEENAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"PAYEEACCBANKNAME", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"PAYEEACCBANK", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"AMOUNT", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"TRANSFERTYPE", (String)"0");
        JDomUtils.addChild((Element)body, (String)"PAYUSE", (String)ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u51fa", (String)"OtherBankCompanyPayImpl_0", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]));
        String explanation = paymentInfo.getExplanation();
        if (StringUtils.isNotEmpty((String)explanation) && explanation.length() > 100) {
            explanation = explanation.substring(0, 100);
        }
        JDomUtils.addChild((Element)body, (String)"REMARK", (String)explanation);
        JDomUtils.addChild((Element)body, (String)"SERIALNO", (String)paymentInfo.getBankDetailSeqId());
        String requestStr = CommonUtil.getPackerData(Constants.OTHER_BANK_COMPANY_PAYMENT, body);
        return requestStr;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        String status = body.getChildText("STATUS");
        String retMsg = body.getChildText("RETMSG");
        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)status, (String)retMsg);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.OTHER_BANK_COMPANY_PAYMENT;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u5bf9\u516c\u4ed8\u6b3e", (String)"OtherBankCompanyPayImpl_1", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

