/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.payment.individual;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crbc.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.crbc.dc.service.utils.Constants;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualQueryPayImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element body = new Element("BODY");
        JDomUtils.addChild((Element)body, (String)"BATCH_NO", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"BSN_CODE", (String)Constants.INDIVIDUAL_PAYMENT);
        String requestStr = CommonUtil.getPackerData(Constants.INDIVIDUAL_PAYMENT_QUERY, body);
        return requestStr;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element element = CommonUtil.resSuccessCheck(res);
        Element body = element.getChild("BODY");
        Element array = body.getChild("ARRAY");
        if (array == null) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        List list = array.getChildren("STRUCT");
        HashMap<String, PaymentInfo> paymentInfoHashMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfoHashMap.put(paymentInfo.getBankDetailSeqId(), paymentInfo);
        }
        for (Element arrayElement : list) {
            String serialNo = arrayElement.getChildText("SERIALNO");
            String status = arrayElement.getChildText("TRAN_STATE");
            String retMsg = arrayElement.getChildText("HOST_MSG");
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfoHashMap.get(serialNo);
            if (paymentInfo == null) {
                this.logger.info("\u94f6\u884c\u8fd4\u56de\u7684ERP\u6d41\u6c34{}\u65e0\u6cd5\u5339\u914d\u4ed8\u6b3e", (Object)serialNo);
                continue;
            }
            if ("90".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)status, (String)retMsg);
                continue;
            }
            if ("92".equals(status) || "99".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)status, (String)retMsg);
                continue;
            }
            if ("50".equals(status) || "41".equals(status) || "42".equals(status) || "43".equals(status) || "44".equals(status) || "45".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)status, (String)retMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)status, (String)retMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return Constants.INDIVIDUAL_PAYMENT_QUERY;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u4ed8\u6b3e\u67e5\u8be2", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-crbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/presystem/access");
    }
}

