/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CommonUtil.class);

    public static String getPackerData(String tranCode, Element body) throws EBServiceException {
        Element head = new Element("HEAD");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String formatTime = LocalDateTime.now().format(dateTimeFormatter);
        JDomUtils.addChild((Element)head, (String)"TRAN_CODE", (String)tranCode);
        JDomUtils.addChild((Element)head, (String)"TRAN_TIME", (String)formatTime);
        Element element = new Element("CRBANK");
        JDomUtils.addChild((Element)element, (Element)head);
        JDomUtils.addChild((Element)element, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestStr = JDomUtils.root2String((Element)element, (String)encoding);
        return requestStr;
    }

    public static Element resSuccessCheck(String res) {
        String encoding = RequestContextUtils.getCharset();
        Element element = JDomUtils.string2Root((String)res, (String)encoding);
        Element head = element.getChild("HEAD");
        String retCode = head.getChildTextTrim("RET_CODE");
        String retMsg = head.getChildTextTrim("RET_MSG");
        if (!"000000".equals(retCode)) {
            logger.error("\u63a5\u53e3\u54cd\u5e94\u5931\u8d25{}", new Object[]{retMsg});
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)retMsg));
        }
        return element;
    }
}

