/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sxnxs.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.AmountUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.MessageUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.ParserRsp;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element Request = MessageUtil.getHead("S11510", "YQBC03", Sequence.gen14Sequence());
        Element Body = new Element("Body");
        JDomUtils.addChild((Element)Body, (String)"AcctNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Request, (Element)Body);
        String encoding = RequestContextUtils.getCharset();
        String xml = JDomUtils.root2String((Element)Request, (String)encoding);
        return MessageUtil.getSendMsg(xml);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        BankResponse res = ParserRsp.parseRsp(s);
        if (!"S".equals(res.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{res.getResponseCode(), res.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        balanceInfo.setBankAcnt(bankAcnt);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("Body");
        String AcctBalance = body.getChildText("AcctBalance");
        String USEBAL = body.getChildText("USEBAL");
        this.setCurrentBalance(balanceInfo, AcctBalance, 100);
        if (StringUtils.isNotEmpty((String)USEBAL)) {
            this.setAvailableBalance(balanceInfo, AmountUtil.getAmountToEas(USEBAL).toString());
        }
        this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency());
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), body.getChildText("AcctNo"));
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "YQBC03";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]);
    }
}

