/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qlb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qlb.dc.service.QLB_Constants;
import kd.ebg.aqap.banks.qlb.dc.service.QLB_Parser;
import kd.ebg.aqap.banks.qlb.dc.service.balance.BalancePakcer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance,
QLB_Constants {
    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CBE001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest bankBalanceRequest) {
        return false;
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return BalancePakcer.packTodayBalance(bankBalanceRequest);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BankResponse resp = QLB_Parser.parserCommonHead(rspStr);
        if (!"0000".equals(resp.getResponseCode())) {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%s", (String)"BalanceParser_1", (String)"ebg-aqap-banks-qlb-dc", (Object[])new Object[0]), resp.toString()));
        }
        Element root = QLB_Parser.parseRootElement(rspStr);
        Element opResult = root.getChild("opRep").getChild("opResult");
        String currentBalance = opResult.getChildTextTrim("CurrentBalance");
        String freeBalance = opResult.getChildTextTrim("FreeBalance");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, rqst.getAcnt());
        this.setBankCurrency(balanceInfo, rqst.getBankCurrency());
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, currentBalance);
        this.setAvailableBalance(balanceInfo, freeBalance);
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(1);
        infos.add(balanceInfo);
        return new EBBankBalanceResponse(infos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/yqbank/APIQLReqServlet");
    }
}

