/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.srdc.service.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.srdc.BankBusinessConfig;
import kd.ebg.aqap.banks.psbc.srdc.Packer;
import kd.ebg.aqap.banks.psbc.srdc.service.payment.PayParser;
import kd.ebg.aqap.banks.psbc.srdc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.psbc.srdc.util.PackerUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "C001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u652f\u4ed8", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !BankBusinessConfig.isPaymetByAuthorized();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8f6c\u8d26\u652f\u4ed8(C001)\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createReqRootElement("C001");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Pay_Account", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Pay_Name", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Param, (String)"Sub_Pay_Account", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Sub_Pay_Name", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Rec_Name", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Account", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Param, (String)"Rec_Bank", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)Param, (String)"Rec_Bank_Id", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Param, (String)"Amount", (String)PackerUtils.convertYuan2CentStr(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Param, (String)"EnterpriseID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)Param, (String)"VoucherID", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Area_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Usage", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Abs_Code", (String)"");
        String remark = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            remark = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)paymentInfo.getExplanation());
        } else {
            remark = paymentInfo.getExplanation();
        }
        JDomUtils.addChild((Element)Param, (String)"Remark", (String)PaymentUtil.substringChinese((boolean)false, (String)remark, (int)40, (String)RequestContextUtils.getCharset()));
        JDomUtils.addChild((Element)Param, (String)"Same_Bank", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)Param, (String)"Same_City", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)Param, (String)"Hurry_Flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)Param, (String)"Xchg_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Person_Flag", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        PackerUtils.optimize(Param);
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            return xmlStr;
        }
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return new PayParser().parser(request, responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            super.configFactory(factory);
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }
}

