/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.ecny.service.ecny.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.ecny.service.ecny.EcnyUtil;
import kd.ebg.aqap.banks.cmb.ecny.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.ecny.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.ecny.util.MsgParser;
import kd.ebg.aqap.banks.cmb.ecny.util.PostUtil;
import kd.ebg.aqap.business.balance.BalanceMethod;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceMethod.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.detailWithPage(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detailWithPage(request);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public boolean match(BankDetailRequest request) {
        return true;
    }

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        JSONObject ntqacinfx = new JSONObject();
        String busMod = EcnyUtil.getN70020Mod(accNo);
        ntqacinfx.put("busmod", (Object)busMod);
        ntqacinfx.put("walletId", (Object)accNo);
        ntqacinfx.put("clientId", (Object)EcnyUtil.getCilentId(acnt.getAccNo()));
        ntqacinfx.put("beginTransDate", (Object)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ntqacinfx.put("endTransDate", (Object)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ntqacinfx.put("queryType", (Object)"A");
        JSONArray array = new JSONArray();
        array.add((Object)ntqacinfx);
        JSONObject body = new JSONObject();
        body.put("BDMTRSQYX1", (Object)array);
        if (this.getCurrentPage() != null && !"empty".equals(this.getCurrentPage())) {
            body.put("BDMTRSQYY1", (Object)this.getCurrentPage());
        }
        String bizCode = "TRANSLIST";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.gen18Sequence());
        JSONObject req = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(req, logger, bizCode);
    }

    private EBBankDetailResponse detailWithPage(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("empty");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse parse(BankDetailRequest req, String rspStr) {
        rspStr = MsgParser.getReceMsg(rspStr, logger);
        return this.parseResult(req, rspStr);
    }

    public EBBankDetailResponse parseResult(BankDetailRequest req, String rspStr) {
        BankResponse response = MsgParser.getResponse(rspStr, logger);
        if (!"SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]), response.getResponseMessage()));
        }
        Object nextPageTag = this.getNextPageTage(rspStr);
        this.setLastPage(this.isLastPage(nextPageTag));
        this.setCurrentPage(nextPageTag);
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqacinfz = body.getJSONArray("BDMTRSQYZ1");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        if (ntqacinfz == null || ntqacinfz.size() == 0) {
            this.setLastPage(true);
            return new EBBankDetailResponse(detailList);
        }
        for (int i = 0; i < ntqacinfz.size(); ++i) {
            JSONObject obiect = ntqacinfz.getJSONObject(i);
            String etydat = obiect.getString("transDate");
            String etytim = obiect.getString("machineTime");
            String explanation1 = obiect.getString("remarkTextClt");
            String trsamt = obiect.getString("transAmount");
            String amtcdr = obiect.getString("direction");
            String trsblv = obiect.getString("acctOnlineBal");
            String transWalletId = obiect.getString("transWalletId");
            String oppAccName = obiect.getString("ctpAcctName");
            String oppAccNo = obiect.getString("ctpAcctNbr");
            String rpybbn = obiect.getString("ctpAcctOpnBankId");
            String refnbr = obiect.getString("messageId");
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(transWalletId);
            detail.setCurrency(req.getHeader().getBankCurrency());
            if ("D".equalsIgnoreCase(amtcdr)) {
                detail.setDebitAmount(new BigDecimal(trsamt).abs());
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equalsIgnoreCase(amtcdr)) {
                detail.setCreditAmount(new BigDecimal(trsamt).abs());
                detail.setDebitAmount(ParserUtils.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u8bc6\u5b57\u6bb5direction\u4e0d\u6b63\u786e\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]));
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            String transSequence = obiect.getString("transSequence");
            detail.setBizRefNo(transSequence);
            detail.setBankDetailNo(refnbr);
            LocalDateTime transTime = null;
            if (StringUtils.isEmpty((String)etydat)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]));
            }
            try {
                transTime = StringUtils.isEmpty((String)etytim) ? LocalDateTime.parse(etydat + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(etydat + etytim, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            detail.setTransTime(transTime);
            detail.setTransDate(LocalDate.parse(etydat, DateTimeFormatter.BASIC_ISO_DATE));
            if (!StringUtils.isEmpty((String)trsblv)) {
                detail.setBalance(new BigDecimal(trsblv));
            }
            detail.setExplanation(explanation1);
            JSONObject obiectDetail = ntqacinfz.getJSONObject(i);
            obiectDetail.put("etydat", (Object)etydat);
            obiectDetail.put("refnbr", (Object)refnbr);
            String jsonStr = obiectDetail.toJSONString();
            detail.setJsonMap(jsonStr);
            String accNo = req.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            detailList.add(detail);
        }
        logger.info("\u89e3\u6790\u5230\u7684\u660e\u7ec6\u6570\u91cf\u4e3a\uff1a" + detailList.size());
        return new EBBankDetailResponse(detailList);
    }

    private Object getNextPageTage(String rspStr) {
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntrbptrsz1 = body.getJSONArray("BDMTRSQYY1");
        JSONObject first = (JSONObject)ntrbptrsz1.get(0);
        String cotflg = first.getString("resumeFlag");
        if ("Y".equalsIgnoreCase(cotflg)) {
            return ntrbptrsz1;
        }
        return "empty";
    }

    private boolean isLastPage(Object pageTag) {
        return Objects.equals(pageTag, "empty");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "TRANSLIST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94b1\u5305\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

