/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.dc.services.utils;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.aqap.banks.bbgb.dc.BankBusinessConfig;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Packer {
    public static final int pageSize = 100;

    public static JSONObject createHeader() {
        JSONObject header = new JSONObject();
        header.put("seqNo", (Object)Sequence.gen18Sequence());
        header.put("tranDate", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        header.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.customNo));
        header.put("userId", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.userId));
        return header;
    }

    public static JSONObject packBalance(BankBalanceRequest bankBalanceRequest) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        body.put("accountNo", (Object)acnt.getAccNo());
        body.put("currencyType", (Object)bankBalanceRequest.getBankCurrency());
        JSONObject balanceJson = new JSONObject();
        balanceJson.put("SYS_HEAD", (Object)header);
        balanceJson.put("BODY", (Object)body);
        return balanceJson;
    }

    public static JSONObject packDetail(BankDetailRequest bankDetailRequest, String pageTag) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        body.put("accountNo", (Object)bankDetailRequest.getAcnt().getAccNo());
        String testDate = RequestContextUtils.getBankParameterValue((String)"testServerDate8");
        if (StringUtils.isNotEmpty((String)testDate)) {
            body.put("startDate", (Object)testDate);
            body.put("endDate", (Object)testDate);
        } else {
            body.put("startDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            body.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        body.put("turnPageBeginPos", (Object)pageTag);
        body.put("turnPageShowNum", (Object)String.valueOf(100));
        body.put("tranKind", (Object)"A");
        body.put("histKind", (Object)"0");
        JSONObject detailJson = new JSONObject();
        detailJson.put("SYS_HEAD", (Object)header);
        detailJson.put("BODY", (Object)body);
        return detailJson;
    }

    public static JSONObject packPay(PaymentInfo paymentInfo) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        String timeAnd6NumSequence = Sequence.genDateTimeAnd6NumSequence();
        String bankSeqNo = RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.customNo) + timeAnd6NumSequence;
        paymentInfo.setBankSerialNo(bankSeqNo);
        body.put("orderFlowNo", (Object)bankSeqNo);
        body.put("payAccount", (Object)paymentInfo.getAccNo());
        body.put("payAccountName", (Object)paymentInfo.getAccName());
        body.put("payAmount", (Object)paymentInfo.getAmount().toPlainString());
        body.put("recAccount", (Object)paymentInfo.getIncomeAccNo());
        body.put("recAccountName", (Object)paymentInfo.getIncomeAccName());
        body.put("recAccountOpenBank", (Object)paymentInfo.getIncomeBankName());
        body.put("unionBankNo", (Object)paymentInfo.getIncomeCnaps());
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        if (addKDFlagToPay) {
            paymentInfo.setKdFlagID(paymentInfo.getBankBatchSeqID());
            body.put("payUse", (Object)BizNoUtil.cont((String)paymentInfo.getBankBatchSeqID(), (String)paymentInfo.getExplanation()));
        } else {
            body.put("payUse", (Object)paymentInfo.getExplanation());
        }
        JSONObject payJson = new JSONObject();
        payJson.put("SYS_HEAD", (Object)header);
        payJson.put("BODY", (Object)body);
        return payJson;
    }

    public static JSONObject packQueryPay(PaymentInfo paymentInfo) {
        JSONObject header = Packer.createHeader();
        JSONObject body = new JSONObject();
        body.put("orderFlowNo", (Object)paymentInfo.getBankSerialNo());
        JSONObject queryPayJson = new JSONObject();
        queryPayJson.put("SYS_HEAD", (Object)header);
        queryPayJson.put("BODY", (Object)body);
        return queryPayJson;
    }
}

