/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.batch;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.service.payment.PayParse;
import kd.ebg.aqap.banks.hnb.dc.service.payment.batch.BatchNoQuery;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BatchQueryPayImpl.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "200202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2", (String)"BatchQueryPayImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        Element root = HNB_DC_Packer.buildHead("200202", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqID());
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"serial_no");
        if (StringUtils.isEmpty((String)serial_no)) {
            EBBankPayResponse response = new BatchNoQuery().doBiz(request);
            serial_no = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)response.getPaymentInfos().get(0)), (String)"serial_no");
            PaymentInfoSysFiled.set((List)request.getPaymentInfos(), (String)"serial_no", (String)serial_no);
        }
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        responseStr = responseStr.substring(responseStr.indexOf("<ap>"));
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        String[] splits = PayParse.parserCommon(responseStr);
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            String cert_no = splits[fieldNum * i + 4];
            String STAT = splits[fieldNum * i + 25];
            String ERR_MSG = splits[fieldNum * i + 26];
            PaymentInfo payInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)cert_no);
            if (null == payInfo) continue;
            if ("6".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BatchQueryPayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("9".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BatchQueryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BatchQueryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("3".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchQueryPayImpl_3", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BatchQueryPayImpl_4", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

