/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uobsg.dc.services.handler;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uobsg.dc.utils.Helper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field34F;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class UOBSG_DC_MT942_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(UOBSG_DC_MT942_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("M42");
    }

    protected List<SwiftTextBlock> readFileContentAsString(File file) throws Exception {
        StringBuilder buffer = new StringBuilder();
        ArrayList<SwiftTextBlock> list = new ArrayList<SwiftTextBlock>();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
            }
            String content = "{4:\n" + buffer.toString().trim() + "\n-}";
            SwiftTextBlock swiftTextBlock = new SwiftTextBlock();
            swiftTextBlock.setUnParserText(content);
            swiftTextBlock.parserText();
            list.add(swiftTextBlock);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6" + file.getName() + "\u53d1\u751f\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return list;
    }

    public void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List<SwiftTextBlock> list = this.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.logger.info(aList.getUnParserText());
                this.parseCurrDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s", (String)"UOBSG_DC_MT942_Handler_1", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), name, e.getMessage()), (Throwable)e);
        }
    }

    private void parseCurrDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        this.logger.info("Field25:" + field25.toString());
        Field34F field34F = new Field34F(swiftTextBlock.getTagValue("34F"));
        String acntNumber = field25.getComponent1();
        String currency = field34F.getComponent1();
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailList, List<PaymentInfo> payInfoList) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            OverseaDetail detail = new OverseaDetail();
            detail.setCustomId(EBContext.getContext().getCustomID());
            String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String time = today.substring(0, 4) + field61.getComponent2();
            if (!today.equals(time)) {
                this.logger.info(ResManager.loadKDString((String)"\u8be5\u7b14\u660e\u7ec6\u4ea4\u6613\u65e5\u671f\u4e0d\u662f\u4eca\u5929\uff0c\u4e0d\u8fdb\u884c\u89e3\u6790", (String)"UOBSG_DC_MT942_Handler_2", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]));
                continue;
            }
            detail.setTxDate(LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setNumber(acntNumber);
            detail.setPayBankName("UOBSG");
            detail.setPayBankVersion(this.context.getBankVersionID());
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCurrency(currency);
            detail.setTransType(field61.getComponent6());
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411.", (String)"UOBSG_DC_MT942_Handler_3", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            this.logger.info("Field61:" + field61.toString());
            String beneficiary = field61.getComponent9();
            detail.setBenefitAccName(StringUtils.isEmpty((String)beneficiary) ? "" : beneficiary);
            String explanation = String.join((CharSequence)" ", Lists.newArrayList((Object[])new String[]{Helper.transType(field61.getComponent6()), custRef, field61.getComponent8() == null ? "" : field61.getComponent8()}));
            detail.setExplanation(explanation.replace("//", "").trim());
            detailList.add(detail);
        }
    }
}

